require "story"

story_table =
{
  {
    {
    init = function()
      global.built_rail = 0
      set_goal({"place-rail-objective", global.built_rail, 4})
      set_info(
      {
        text = {"place-rail"},
        pictures = 
        {
          {path = "file/place-rail-1.png"},
          {path = "file/place-rail-2.png"}
        }
      })
      game.players[1].insert{name = "rail", count = 1000}
    end,
    condition = function(event)
      if event.name ~= defines.events.on_built_entity then return false end
      if event.created_entity.name ~= "straight-rail" then return false end
      if event.created_entity.direction ~= 2 then return false end
      if not global.first_rail_offset_Y then global.first_rail_offset_Y = event.created_entity.position.y end
      global.built_rail = global.built_rail + 1
      set_goal({"place-rail-objective", global.built_rail, 4}, true)
      if global.built_rail ~= 4 then return false end
      set_goal({"place-rail-objective", global.built_rail, 4})
      global.built_rail = nil
      return true
    end
    },
    {
      init = function()
        set_goal({"place-curved-rail"})
        set_info({text = {"place-curved-rail-info"}, 
          pictures = 
          {
            {path = "file/place-curved-rail-1.png"},
            {path = "file/place-curved-rail-2.png"},
            {path = "file/place-curved-rail-3.png", split = true}
          }
        })
      end,
      condition = function(event)
        if event.name ~= defines.events.on_built_entity then return false end
        if event.created_entity.name ~= "curved-rail" then return false end
        return true
      end,
      action = function()
        global.first_rail_offset_Y = math.max(-31, global.first_rail_offset_Y)
        global.first_rail_offset_Y = math.min(9, global.first_rail_offset_Y)
        set_ghost_rails(global.rail_ghosts_1, global.first_rail_offset_Y+11)
        global.remaining = #global.current_ghosts
      end
    },
    {
      init = function()
        set_goal({"rail-planner-objective", 0, global.remaining})
        set_info(
        {
          text = {"rail-planner-info"},
          pictures = 
          {
            {path = "file/rail-planner-1.png"},
            {path = "file/rail-planner-2.png"}
          }
        })
      end,
      condition = function() 
        local finished = true
        local remaining = 0
        local count = 0
        for k, rail in pairs (global.current_ghosts) do
          if rail.valid then 
            finished = false
            remaining = remaining + 1
          end
          count = count + 1
        end
        if global.remaining ~= remaining then
          set_goal({"rail-planner-objective", count-remaining, count}, true)
          global.remaining = remaining
        end
        return finished
      end,
      action = function(event)
        set_goal({"rail-planner-objective", #global.current_ghosts, #global.current_ghosts})
        game.players[1].clean_cursor()
      end
    },
    {
      init = function()
        set_goal()
        game.show_message_dialog{text = {"finished-rail-planning"}}
        set_goal({"place-train"})
        set_info({text = {"place-train-info"}, picture = "file/place-train.png"})
        game.players[1].insert{name = "locomotive", count = 1}
        clear_rails(game.surfaces[1])
        set_ghost_rails(global.rail_ghosts_1, global.first_rail_offset_Y+11,true)
        game.players[1].remove_item{name = "rail", count = 1000}
      end,
      condition = function(event) return (event.name == defines.events.on_built_entity and event.created_entity.name == "locomotive") end,
      action = function(event) 
        global.locomotive = event.created_entity
        global.locomotive.minable = false
      end
    },
    {
      init = function()
        set_goal({"place-fuel"})
        set_info()
        game.players[1].insert{name = "coal", count = 20}
        game.players[1].get_quickbar().insert{name = "coal", count = 20}
      end,
      condition = function() return
        (global.locomotive.get_item_count("coal") > 0)
      end
    },
    {
      init = function()
        set_goal({"enter-train"})
        set_info()
      end,
      condition = function() 
        return (game.players[1].vehicle == global.locomotive)
      end,
    },
    {
      init = function()
        set_goal({"drive-forward"})
        set_info()
      end,
      condition = function()
        return global.locomotive.train.speed > 0.5
      end
    },
    {
    init = function() 
      set_goal({"stop-train"})
      set_info()
    end,
    condition = function()
      return (global.locomotive.train.speed == 0)
    end
    },
    {
    condition = story_elapsed_check(1),

    },
    {
    init = function() 
      set_goal({"drive-backward"})
      set_info()
    end,
    condition = function()
      return global.locomotive.train.speed <= -0.2
    end
    },
    {
    init = function()
      set_goal({"steer-train"})
      set_info({text = {"steer-train-info"}})
      set_ghost_rails(global.rail_ghosts_2, global.first_rail_offset_Y-11, true)
      global.Y_threshold = global.first_rail_offset_Y + 8
    end,
    condition = function()
      return (global.locomotive.position.y > global.Y_threshold)
    end
    },
    {
      condition = story_elapsed_check(2),
      action = function ()
        set_goal()
        set_info()
        game.show_message_dialog({text = {"finish"}})
      end,
    },
  }
}

story_init_helpers(story_table)

script.on_init(function()
  get_ghost_rails()
  game.surfaces[1].always_day = true
  global.story = story_init(story_table)
end)

script.on_event(defines.events, function(event)
  story_update(global.story, event, "")
end)

function get_ghost_rails()
  global.rail_ghosts_1 = {}
  local area = {{-25,-48}, {25,-5}}
  local surface = game.surfaces[1]
  for k, entity in pairs (surface.find_entities(area)) do
    table.insert(global.rail_ghosts_1,{name = "entity-ghost", ghost_name = entity.name, force = entity.force.name, position = entity.position, direction = entity.direction})
    entity.destroy()
  end
  global.rail_ghosts_2 = {}
  local area = {{-15,0}, {15,40}}
  local surface = game.surfaces[1]
  for k, entity in pairs (surface.find_entities(area)) do
    table.insert(global.rail_ghosts_2,{name = "entity-ghost", ghost_name = entity.name, force = entity.force.name, position = entity.position, direction = entity.direction})
    entity.destroy()
  end
end

function set_ghost_rails(rails, Y_offset, revive)
  if not global.current_ghosts then global.current_ghosts = {} end
  local surface = game.surfaces[1]
  if Y_offset < -22 then Y_offset = -22 end
  if Y_offset > 40 then Y_offset = 40 end
  for k, ghost in pairs (rails) do
    if surface.can_place_entity{name = ghost.ghost_name, force = game.players[1].force, position = {ghost.position.x, ghost.position.y+Y_offset}, direction = ghost.direction} then
      local rail = surface.create_entity
      {
        name = ghost.name,
        inner_name = ghost.ghost_name,
        force = game.players[1].force,
        position = {ghost.position.x, ghost.position.y+Y_offset},
        direction = ghost.direction,
        expires = false
      }
      rail.minable = false
      table.insert(global.current_ghosts, rail)
      if revive then rail.revive() end
    end
  end
  global.initial_ghosts = #global.current_ghosts
end

function clear_rails(surface)
  for k, rail in pairs (surface.find_entities_filtered{type = "straight-rail"}) do
    rail.destroy()
  end
  for k, rail in pairs (surface.find_entities_filtered{type = "curved-rail"}) do
    rail.destroy()
  end
  for k, rail in pairs (surface.find_entities_filtered{type = "entity-ghost"}) do
    rail.destroy()
  end
end
