require "story"
required_path = 15
through_wall_path = 50
story_table =
{
  { 
    {
      init = function()
        global.built_rail = 0
        set_goal({"place-ghost-rail", global.built_rail, 4})
        set_info({text = {"place-ghost-rail-info"}, pictures = {"file/place-ghost-rail-1.png", "file/place-ghost-rail-2.png"}})
        game.players[1].insert{name = "rail", count = 1000}
      end,
      condition = function(event)
        if event.name ~= defines.events.on_built_entity then return false end
        local entity = event.created_entity
        if not entity.valid then return end
        if entity.name ~= "entity-ghost" then return false end
        if entity.ghost_name ~= "straight-rail" then return false end
        global.built_rail = global.built_rail + 1
        set_goal({"place-ghost-rail", global.built_rail, 4}, true)
        if global.built_rail ~= 4 then return false end
        set_goal({"place-ghost-rail", global.built_rail, 4})
        global.built_rail = nil
        return true
      end
    },
    {
      init = function() 
        global.max_placed_length = 0
        global.current_ghosts = current_ghosts_count()
        set_goal({"start-ghost-rail-planning", required_path, global.max_placed_length})
        set_info(
        {
          text = {"start-ghost-rail-planning-info"},
          pictures = 
          {
            "file/ghost-plan-1.png",
            "file/ghost-plan-2.png",
            {path = "file/ghost-plan-3.png", split = true}
          }
        })
      end,
      update = function (event)
        if event.name == defines.events.on_tick then
          local diff = current_ghosts_count() - global.current_ghosts
          global.max_placed_length = math.max(diff, global.max_placed_length)
          global.current_ghosts = current_ghosts_count()
          set_goal({"start-ghost-rail-planning", required_path, global.max_placed_length}, (not (global.max_placed_length >= required_path)))
        end
      end,
      condition = function()
        return global.max_placed_length >= required_path
      end,
      action = function()
        
      end
    },
    {
      condition = story_elapsed_check(2)
    },
    {
      init = function()
        set_goal({"rotate-rail"})
        set_info({text = {"rotate-rail-info"}, picture = "file/rotate-rail.png"})
        local surface = game.surfaces[1]
        for k, v in pairs (surface.find_entities_filtered{name = "entity-ghost"}) do
          v.destroy()
        end
        surface.create_entity
        {
          name = "entity-ghost",
          inner_name = "straight-rail",
          direction = 2,
          position = {-7, -3},
          force = "player",
          expires = false
        }.minable = false
        surface.create_entity
        {
          name = "entity-ghost",
          inner_name = "straight-rail",
          direction = 2,
          position = {9,3},
          force = "player",
          expires = false
        }.minable = false
      end,
      condition = function(event)
        if event.name ~= defines.events.on_tick then return end
        local rails = 
        {
          {position = {-2, -2}, area = {{-3, -3}, {-1,-1}}, direction = 3},
          {position = {4, 2}, area = {{5, 1}, {3, 3}}, direction = 7}
        }
        local surface = game.surfaces[1]
        count = 0
        for k, ghost in pairs (surface.find_entities_filtered({name = "entity-ghost"})) do
          for j, rail in pairs (rails) do
            if ghost.ghost_name == "curved-rail" and
               ghost.position.x == rail.position[1] and
               ghost.position.y == rail.position[2] and
               ghost.direction == rail.direction then
              count = count + 1
              break
            end
          end
        end
        if count >= 2 then
          return true
        end
        local any_destroyed = false
        for k, rail in pairs (surface.find_entities_filtered({name = "entity-ghost"})) do
          if rail.name ~= "player" and rail.minable then
            rail.destroy()
            any_destroyed = true
          end
        end
        if any_destroyed then
          game.print({"rotate-rail-not-1-tick"})
          game.players[1].clean_cursor()
        end
      end,
      action = function()
        for k, rail in pairs (game.surfaces[1].find_entities_filtered{name = "entity-ghost"}) do
          rail.destroy()
        end
        game.players[1].clean_cursor()
      end
    },
    {
      init = function()
        game.players[1].clean_cursor()
        set_goal({"trace-path"})
        set_info()
        local surface = game.surfaces[1]
        game.players[1].character_mining_speed_modifier = -1
        for k, entity in pairs (surface.find_entities()) do
          if entity.name ~= "player" then
            entity.destroy()
          end
        end
        set_entities(global.set_rails)
        set_entities(global.other)
        global.text = 
        {
          surface.create_entity{name = "flying-text", text = {"connect-start"}, position = {-17, -12.5}},
          surface.create_entity{name = "flying-text", text = {"connect-end"}, position = {-16, 9.5}}
        }
        for k, text in pairs (global.text) do
          text.active = false
        end
        
      end,
      condition = function() 
        local surface = game.surfaces[1]
        local count = 0
        for k, entity in pairs (global.rails) do
          local ghost = surface.find_entity("entity-ghost", entity.position)
          if ghost then
            count = count + 1
          else
            local area = {{entity.position.x-2, entity.position.y-2}, {entity.position.x+2, entity.position.y+2}}
            for j, ghost in pairs (surface.find_entities_filtered{area = area, name = "entity-ghost"}) do
              if ((ghost.position.x == entity.position.x) and (ghost.position.y == entity.position.y) and (ghost.ghost_name == entity.name)) then
                count = count + 1
                break
              end
            end
          end
        end
        return count >= #global.rails
      end,
      action = function()
        for k, arrow in pairs (global.text) do
          if arrow.valid then
            arrow.destroy()
          end
        end
        global.arrows = nil
      end
    },
    {
      init = function()
        game.players[1].clean_cursor()
        set_goal({"force-through-obstacles"})
        set_info({text = {"force-through-obstacles-info"}, picture = "file/through-obstacles.png"})
      end,
      condition = function() 
        --should deconstruct 3 trees and the stone rock, so 4 in total.
        local count = 0
        local some_rail = false
        local surface = game.surfaces[1]
        for k, tree in pairs (surface.find_entities_filtered{type = "tree"}) do
          if tree.to_be_deconstructed("player") then
            count = count + 1
            if surface.find_entities_filtered{area = tree.bounding_box, name = "entity-ghost"}[1] then
              some_rail = true
            end
          end
        end
        for k, rock in pairs (surface.find_entities_filtered{name = "stone-rock"}) do
          if rock.to_be_deconstructed("player") then
            count = count + 1
            if surface.find_entities_filtered{area = rock.bounding_box, name = "entity-ghost"}[1] then
              some_rail = true
            end
          end
        end
        return count >= 4 and some_rail
      end,
      action = function()
        set_goal({"force-through-obstacles"})
      end
    },
    {
      condition = story_elapsed_check(2),
      action = function()
        for k, entity in pairs (game.surfaces[1].find_entities()) do
          if entity.name ~= "player" then
            entity.destroy()
          end
        end
        game.players[1].clean_cursor()
      end
    },
    {
      init = function()
        set_goal({"crazy-rail", current_ghosts_count({{-50, -50}, {50, 50}}), through_wall_path})
        set_info({text = {"crazy-rail-info"}})
        local surface = game.surfaces[1]
        local rand = math.random
        for k = 1, 200 do
          local position = {rand(-52,51), rand(-51,52)}
          if surface.can_place_entity{name = "stone-rock", position = position} then
            surface.create_entity{name = "stone-rock", position = position, force = "player"}
          end
        end
        surface.create_entity{name = "entity-ghost", inner_name = "straight-rail", direction = 2, position = {-59, 1}, force = "player", expires = false}
        surface.create_entity{name = "entity-ghost", inner_name = "straight-rail", direction = 2, position = {59, 1}, force = "player", expires = false}
        surface.create_entity{name = "entity-ghost", inner_name = "straight-rail", direction = 0, position = {1, 59}, force = "player", expires = false}
        surface.create_entity{name = "entity-ghost", inner_name = "straight-rail", direction = 0, position = {1, -59}, force = "player", expires = false}
      end,
      condition = function(event)
        if event.name ~= defines.events.on_tick then return end
        local surface = game.surfaces[1]
        local bool = current_ghosts_count({{-50, -50}, {50, 50}}) >= through_wall_path
        set_goal({"crazy-rail", current_ghosts_count({{-50, -50}, {50, 50}}), through_wall_path}, (not bool))
        return bool
      end
    },
    {
      condition = story_elapsed_check(2),
      action = function ()
        set_goal()
        set_info()
        game.show_message_dialog({text = {"finish"}})
      end,
    },
  }
}

story_init_helpers(story_table)

script.on_init(function()
  game.surfaces[1].always_day = true
  global.story = story_init(story_table)
  get_ghost_rails()
end)

script.on_event(defines.events, function(event)
  check_built_real_rail(event)
  story_update(global.story, event, "")
end)

function check_built_real_rail(event)
  if event.name ~= defines.events.on_tick then return end
  local surface = game.surfaces[1]
  local player = game.players[1]
  for k, rail in pairs (surface.find_entities_filtered{type = "straight-rail"}) do
    if rail.minable then
      rail.destroy()
      player.clean_cursor()
      player.insert{name = "rail", count = 1}
      player.print({"placed-real-rail"})
    end
  end
  for k, rail in pairs (surface.find_entities_filtered{type = "curved-rail"}) do
    if rail.minable then
      rail.destroy()
      player.clean_cursor()
      player.insert{name = "rail", count = 4}
      player.print({"placed-real-rail"})
    end
  end
end

function get_ghost_rails()
  global.set_rails = {}
  global.rails = {}
  global.other = {}
  local surface = game.surfaces[1]
  for k, entity in pairs (surface.find_entities()) do
    if entity.minable then
      if (entity.type == "straight-rail") or (entity.type == "curved-rail") then
        table.insert(global.rails,{name = entity.name, force = entity.force.name, position = entity.position, direction = entity.direction})
        entity.destroy()
      else
        table.insert(global.other,{name = entity.name, position = entity.position, force = entity.force})
        entity.destroy()
      end
    else
      table.insert(global.set_rails,{name = entity.name, force = entity.force.name, position = entity.position, direction = entity.direction})
        entity.destroy()
    end
  end
end

function set_entities(entities)
  local surface = game.surfaces[1]
  for k, entity in pairs (entities) do
    if surface.can_place_entity{name = entity.name, force = game.players[1].force, position = entity.position, direction = entity.direction} then
      local rail = surface.create_entity
      {
        name = entity.name,
        force = game.players[1].force,
        position = entity.position,
        direction = entity.direction
      }
      rail.minable = false
      if rail.type == "tree" or rail.name == "stone-rock" then
        rail.minable = true
      end
    end
  end
end

function current_ghosts_count(area)
  if area then 
    return game.surfaces[1].count_entities_filtered{area = area, name = "entity-ghost"}
  else
    return game.surfaces[1].count_entities_filtered{name = "entity-ghost"}
  end
end





