require "story"

story_table =
{
  {
    {
      init = function()
        local stop = game.get_entity_by_tag("stop")
        global.stop = {name = "entity-ghost", inner_name = stop.name, position = stop.position, direction = stop.direction, force = stop.force, expires = false}
        stop.destroy()
        local area = {{-7, -10}, {5, 18}}
        local late_entities = {}
        for k, entity in pairs (game.surfaces[1].find_entities_filtered{area = area}) do
          if entity.type ~= "straight-rail" and entity.name ~= "player" then
            table.insert(late_entities, {name = entity.name, position = entity.position, direction = entity.direction, force = "player"})
            entity.destroy()
          end
        end
        global.late_entities = late_entities
        local entities = {}
        for k, entity in pairs (game.surfaces[1].find_entities()) do
          if entity.type == "straight-rail" and entity.position.y == -5 then
            entity.minable = false
          elseif not (entity.name == "player") then
            table.insert(entities, {name = entity.name, position = entity.position, direction = entity.direction, force = "player"})
            entity.destroy()
          end
        end
        global.entities = entities
      end,
      condition = story_elapsed_check(1)
    },
    {
      init = function()
        set_goal({"place-stop"})
        set_info(
          {
            text = {"place-stop-info"},
            picture = 
            {
              path = "file/place-stop.png",
              style = 
              {
                left_padding = 10
              }
            }
          })
        local stop = game.surfaces[1].create_entity(global.stop)
        stop.minable = false
        stop.backer_name = ""
        global.stop = stop
        game.players[1].insert({name = "train-stop"})
        game.players[1].character_mining_speed_modifier = 5
      end,
      condition = function()
        return not global.stop.valid
      end,
      action = function(event)
        if event.name ~= defines.events.on_entity_renamed then
          global.stop = game.surfaces[1].find_entities_filtered{type = "train-stop"}[1]
          global.stop.backer_name = "Placed station"
          global.stop.minable = false
        end
      end
    },
    {
      init = function()
        set_goal{"place-locomotive"}
        set_info(
        {
          text = {"place-locomotive-info"},
          picture = "file/station-directions.png",
          custom_function = function(gui)
            gui.style.maximal_width = 600
          end
        })
        game.players[1].insert({name = "locomotive"})
      end,
      update = function(event)
        if event.name == defines.events.on_built_entity then
          if event.created_entity.name == "locomotive" then
            global.locomotive = event.created_entity
            if event.created_entity.orientation == 0.75 then
              set_info({text = {"place-locomotive-info"}})
              set_info({text = {"rotate-on-track"}}, true)
              game.print({"locomotive-wrong-direction"})
            end
          end
        end
      end,
      condition = function()
        if not global.locomotive then return end
        if not global.locomotive.valid then return end
        return global.locomotive.orientation == 0.25
      end,
      action = function()
        global.locomotive.insert"coal"
        global.locomotive.minable = false
        global.locomotive.rotatable = false
        global.locomotive.destructible = false
      end
    },
    {
      init = function()
        game.players[1].insert({name = "cargo-wagon"})
        set_goal{"place-wagon"}
        set_info({text = {"place-wagon-info"}, picture = "file/place-wagon.png"})
      end,
      condition = function(event)
        if event.name == defines.events.on_built_entity then
          local train = global.locomotive.train
          if train.front_stock.name == "cargo-wagon" then
            game.print({"placed-wagon-in-front"})
          end
          return train.back_stock.name == "cargo-wagon"
        end
      end,
      action = function(event)
        global.wagon = event.created_entity
        event.created_entity.minable = false
        event.created_entity.destructible = false
      end
    },
    {
      init = function()
        set_goal({"set-schedule"})
        set_info(
        {
          text = {"set-schedule-info", {"gui-train.add-time-condition"}},
          pictures = 
          {
            {path = "file/set-schedule-1.png"},
            {path = "file/set-schedule-2.png", split = true},
            {path = "file/set-schedule-3.png", split = true}
          }
        })
      end,
      condition = function()
        local schedule = global.locomotive.train.schedule
        if not schedule then return end
        local record = schedule.records[1]
        if not record.wait_conditions then return end
        return (record.station == global.stop.backer_name) and (record.wait_conditions[1].type == "time")
      end,
    },
    {
      init = function()
        set_goal({"start-train"})
        set_info({text = {"start-train-info", {"gui-train.automatic-mode"}}, picture = "file/start-train.png"})
      end,
      condition = function()
        return (global.locomotive.train.manual_mode == false)
      end
    },
    {
      init = function()
        set_goal({"fuel-train"})
        set_info({text = {"fuel-train-info"}, picture = "file/fuel-train.png"})
        global.locomotive.operable = false
        global.locomotive.remove_item({name = "coal", count = 50})
        global.locomotive.insert({name = "coal", count = 50})
        game.players[1].get_quickbar().insert"coal"
        game.players[1].insert{name = "burner-inserter"}
        game.players[1].insert{name = "iron-chest"}
      end,
      update = function(event)
        if event.name ~= defines.events.on_built_entity then
          return
        end
        local entity = event.created_entity
        if entity.name == "burner-inserter" then
          global.burner = entity
        end
      end,
      condition = function()
        if not global.burner then return end
        if not global.burner.valid then return end
        if (not global.burner.drop_target) or (not global.burner.pickup_target) then return end
        if not global.burner.drop_target.name == "locomotive" then return end
        if not global.burner.pickup_target.name == "iron-chest" then return end
        return global.locomotive.get_item_count("coal") > 50
      end,
      action = function()
        global.locomotive.operable = true
      end
    },
    {
      init = function()
        local surface = game.surfaces[1]
        global.stack_inserters = {}
        for k, entity in pairs (global.entities) do
          local created
          if not (entity.name == "fast-inserter" and (entity.position.y < 23.5)) then
            created = surface.create_entity(entity)
          end
          created.minable = false
          created.rotatable = false
          if created.backer_name then
            created.backer_name = "Loading station"
            global.loading_station = created
          end
          if created.name == "iron-chest" or created.name == "steel-chest" then
            created.operable = false
            created.insert{name = "iron-ore", count = math.random(2000,2100)}
          end
          if created.name == "wooden-chest" then
            created.operable = false
            created.insert{name = "coal", count = 100}
          end
          if created.name == "stack-inserter" then
            table.insert(global.stack_inserters, created)
            created.active = false
          end
        end
        game.players[1].force.stack_inserter_capacity_bonus = 15
        game.players[1].force.inserter_stack_size_bonus = 1
        set_goal({"loading-station", global.loading_station.backer_name, {"gui-train.add-full-condition"}})
        set_info()
      end,
      condition = function()
        local schedule = global.locomotive.train.schedule
        if not schedule then return end
        local record = schedule.records[2]
        if not record then return end
        if not record.wait_conditions then return end
        return (record.station == global.loading_station.backer_name) and (record.wait_conditions[1].type == "full")
      end,
    },
    {
      init = function()
        set_goal({"goto-station", {"gui-train.goto-station"}, global.loading_station.backer_name})
        set_info({picture = "file/goto-station.png"})
      end,
      condition = function()
        return global.locomotive.train.station and (global.locomotive.train.station == global.loading_station)
      end
    },
    {
      init = function()
        set_goal({"load-wagon"})
        set_info()
        game.players[1].insert{name = "stack-inserter", count = 10}
        global.stack_inserters[1].active = true
        global.stack_inserters[2].active = true
        global.stack_inserters = nil
      end,
      condition = function()
        local schedule = global.locomotive.train.schedule
        if not schedule then return end
        local record = schedule.records[2]
        if not record then return end
        if not record.wait_conditions then return end
        return (record.wait_conditions[1].type == "full") and (not global.wagon.can_insert({name = "iron-ore", count = 1}))
      end,
    },
    {
      init = function()
          set_goal({"add-condition", {"gui-train.add-empty-condition"}, global.stop.backer_name})
          set_info(
          {
            pictures = 
            {
              {path = "file/add-condition-1.png"},
              {path = "file/add-condition-2.png", split = true}
            }
          })
      end,
      condition = function()
        local schedule = global.locomotive.train.schedule
        if not schedule then return end
        local record = schedule.records[1]
        if not record then return end
        if not record.wait_conditions then return end
        local condition = record.wait_conditions[2]
        if not condition then return end
        return (condition.type == "empty")
      end
    },
    {
      init = function()
        set_goal({"remove-condition", {"gui-train.add-time-condition"}})
        set_info({picture = "file/remove-condition.png"})
      end,
      condition = function()
        local schedule = global.locomotive.train.schedule
        if not schedule then return end
        local record = schedule.records[1]
        if not record then return end
        if not record.wait_conditions then return end
        local condition = record.wait_conditions[1]
        if not condition then return end
        return (condition.type == "empty")
      end
    },
    {
      init = function()
        set_goal({"unload-wagon"})
        set_info({text = {"unload-wagon-info"}})
        local surface = game.surfaces[1]
        for k, entity in pairs (global.late_entities) do
          local created = surface.create_entity(entity)
          created.minable = false
        end
        game.players[1].remove_item{name = "stack-inserter", count = 12}
        game.players[1].insert{name = "stack-inserter", count = 12}
      end,
      condition = function()
        local insertered = false
        for k, inserter in pairs (game.surfaces[1].find_entities_filtered{name = "stack-inserter"}) do
          if inserter.pickup_target == global.wagon and inserter.energy > 0 then
            insertered = true
          end
        end
        return insertered and (not global.locomotive.train.get_contents()["iron-ore"])
      end,
      action = function()
        set_goal({"unload-wagon"})
      end
    },
    {
      init = function()
        set_goal({"trains-will-loop"})
        set_info()
        game.players[1].character.destructible = false
      end,
      condition = story_elapsed_check(5),
      action = function() 
        game.speed = 5
      end
    },
    {
      condition = story_elapsed_check(50),
      action = function ()
        set_goal()
        set_info()
        game.show_message_dialog({text = {"finish"}})
      end,
    },
  }
}

story_init_helpers(story_table)

script.on_init(function()
  game.surfaces[1].always_day = true
  global.story = story_init(story_table)
end)

script.on_event(defines.events, function(event)
  story_update(global.story, event, "")
end)