/*
 * Decompiled with CFR 0.152.
 */
package com.af.benchafhelper;

import com.af.benchafhelper.utils.CommandManager;
import com.af.benchafhelper.utils.LogUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.swing.ImageIcon;

public class Main
extends Application {
    private boolean isConnectDevice = false;
    private List<String> devices = new ArrayList<String>();
    private CommandManager commandManager;

    public void start(Stage primaryStage) throws Exception {
        File file = new File("../logcat");
        if (!file.exists()) {
            file.mkdirs();
        }
        LogUtils.init();
        AnchorPane root = new AnchorPane();
        if (root instanceof AnchorPane) {
            final Image imageConnectDefault = new Image(((Object)((Object)this)).getClass().getResource("/images/conn_phone.png").toExternalForm());
            Image icon = new Image(((Object)((Object)this)).getClass().getResource("/images/ic_launcher.png").toExternalForm());
            final Image imageConnectPressed = new Image(((Object)((Object)this)).getClass().getResource("/images/click.png").toExternalForm());
            final Image imageConnectHover = new Image(((Object)((Object)this)).getClass().getResource("/images/hover.png").toExternalForm());
            final Image imageNoDevice = new Image(((Object)((Object)this)).getClass().getResource("/images/no_phone.png").toExternalForm());
            Image leftSquare = new Image(((Object)((Object)this)).getClass().getResource("/images/bg_1.png").toExternalForm());
            Image rightSquare = new Image(((Object)((Object)this)).getClass().getResource("/images/bg_2.png").toExternalForm());
            primaryStage.getIcons().add((Object)icon);
            primaryStage.getIcons().add((Object)icon);
            primaryStage.getIcons().add((Object)icon);
            primaryStage.setTitle("\u5feb\u5426PC\u52a9\u624b");
            final ImageView imageView = new ImageView();
            imageView.setImage(imageNoDevice);
            ImageView leftQquareImageView = new ImageView();
            leftQquareImageView.setImage(leftSquare);
            AnchorPane.setLeftAnchor((Node)leftQquareImageView, (Double)305.0);
            AnchorPane.setTopAnchor((Node)leftQquareImageView, (Double)202.0);
            ImageIcon imageIcon = new ImageIcon("/images/icon.png");
            ImageView rightQquareImageView = new ImageView();
            rightQquareImageView.setImage(rightSquare);
            AnchorPane.setLeftAnchor((Node)rightQquareImageView, (Double)916.0);
            AnchorPane.setTopAnchor((Node)rightQquareImageView, (Double)436.0);
            AnchorPane.setLeftAnchor((Node)imageView, (Double)509.0);
            AnchorPane.setTopAnchor((Node)imageView, (Double)190.0);
            root.getChildren().addAll((Object[])new Node[]{leftQquareImageView, rightQquareImageView, imageView});
            imageView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    LogUtils.writeLog("onMouseClicked");
                    if (Main.this.isConnectDevice) {
                        if (Main.this.devices.size() > 1) {
                            System.out.println("click:devices = " + Main.this.devices.toString());
                            ChoiceDialog choiceDialog = new ChoiceDialog(Main.this.devices.get(0), (Collection)Main.this.devices);
                            choiceDialog.setTitle("\u9009\u62e9\u8981\u6fc0\u6d3b\u7684\u624b\u673a");
                            choiceDialog.setHeaderText("\u68c0\u6d4b\u5230\u60a8\u8fde\u63a5\u4e86\u591a\u4e2a\u8bbe\u5907\uff0c\u8bf7\u9009\u62e9\u8981\u6fc0\u6d3b\u7684\u8bbe\u5907");
                            LogUtils.writeLog("devices = " + Main.this.devices.toString());
                            Optional optionalS = choiceDialog.showAndWait();
                            if (optionalS.isPresent()) {
                                String chooseDevice = ((String)optionalS.get()).replaceAll("(\t| |device)", "");
                                System.out.println("chooseDevice = " + chooseDevice);
                                Main.this.commandManager.activateDevice(chooseDevice);
                            }
                        } else {
                            String device = (String)Main.this.devices.get(0);
                            String chooseDevice = device.replaceAll("(\t| |device)", "");
                            System.out.println("chooseDevice = " + chooseDevice);
                            Main.this.commandManager.activateDevice(chooseDevice);
                        }
                    }
                }
            });
            imageView.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    if (Main.this.isConnectDevice) {
                        imageView.setImage(imageConnectPressed);
                    }
                }
            });
            imageView.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    if (Main.this.isConnectDevice) {
                        imageView.setImage(imageConnectDefault);
                    }
                }
            });
            imageView.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    if (Main.this.isConnectDevice) {
                        imageView.setImage(imageConnectHover);
                    }
                }
            });
            imageView.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    if (Main.this.isConnectDevice) {
                        imageView.setImage(imageConnectDefault);
                    }
                }
            });
            this.commandManager = new CommandManager();
            this.commandManager.setListener(new CommandManager.OnCommandResultListener(){

                @Override
                public void onTestConnResult(List<String> devices) {
                    Main.this.devices.clear();
                    Main.this.devices.addAll(devices);
                    if (devices.size() == 0) {
                        Main.this.isConnectDevice = false;
                        imageView.setImage(imageNoDevice);
                    } else {
                        Main.this.isConnectDevice = true;
                        imageView.setImage(imageConnectDefault);
                    }
                }

                @Override
                public void onActivateResult(String result) {
                    if ("success".equals(result)) {
                        Alert alert = new Alert(Alert.AlertType.INFORMATION);
                        alert.setTitle("\u6fc0\u6d3b\u6210\u529f");
                        alert.setHeaderText(null);
                        alert.setContentText("\u6fc0\u6d3b\u6210\u529f");
                        alert.showAndWait();
                    }
                }

                @Override
                public void onLog(String log) {
                    LogUtils.writeLog(log);
                }

                @Override
                public void onActivateError(String errorData) {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION);
                    alert.setTitle("\u6fc0\u6d3b\u5931\u8d25");
                    alert.setHeaderText(null);
                    alert.setContentText(errorData);
                    alert.showAndWait();
                }
            });
        }
        primaryStage.setTitle("KFMARK");
        Scene scene = new Scene((Parent)root, 1366.0, 768.0);
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                Main.this.commandManager.destroy();
            }
        });
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }
}

