/*
 * Decompiled with CFR 0.152.
 */
package com.af.benchafhelper.utils;

import com.af.benchafhelper.beans.ADBType;
import com.af.benchafhelper.beans.CommandRequestBean;
import com.af.benchafhelper.beans.CommandResultBean;
import com.af.benchafhelper.utils.AnalysisTask;
import com.af.benchafhelper.utils.CommandTask;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class CommandManager
implements Runnable {
    private final ExecutorService executorService;
    private LinkedBlockingQueue<CommandRequestBean> requestBeans = new LinkedBlockingQueue();
    private LinkedBlockingQueue<CommandResultBean> resultBeans = new LinkedBlockingQueue();
    private CommandTask commandTask = new CommandTask(this.requestBeans, this.resultBeans);
    private AnalysisTask analysisTask = new AnalysisTask(this.resultBeans);

    public CommandManager() {
        this.executorService = Executors.newCachedThreadPool();
        this.executorService.execute(this);
        this.executorService.execute(this.commandTask);
        this.executorService.execute(this.analysisTask);
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                TimeUnit.MILLISECONDS.sleep(1000L);
                File file = new File("../adb.exe");
                String adbCanonicalPath = file.getCanonicalPath();
                this.requestBeans.put(new CommandRequestBean(ADBType.TYPE_TEST_CONNECT, adbCanonicalPath + " devices"));
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void activateDevice(String deviceId) {
        try {
            File file = new File("../adb.exe");
            String adbCanonicalPath = file.getCanonicalPath();
            File daemonFile = new File("../daemon");
            String daemonCanonicalPath = daemonFile.getCanonicalPath();
            String command1 = String.format(adbCanonicalPath + " -s %s push " + daemonCanonicalPath + " /data/local/tmp", deviceId);
            String command2 = String.format(adbCanonicalPath + " -s %s shell chmod 777 /data/local/tmp/daemon", deviceId);
            String command3 = String.format(adbCanonicalPath + " -s %s shell \"cd /data/local/tmp;./daemon\"", deviceId);
            StringBuilder activateCommands = new StringBuilder();
            activateCommands.append(command1).append("&&").append(command2).append("&&").append(command3);
            this.requestBeans.put(new CommandRequestBean(ADBType.TYPE_ACTIVATE_RUN, activateCommands.toString()));
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setListener(OnCommandResultListener listener) {
        this.analysisTask.setListener(listener);
    }

    public void destroy() {
        this.executorService.shutdownNow();
        this.analysisTask.destroy();
        this.commandTask.destroy();
    }

    public static interface OnCommandResultListener {
        public void onTestConnResult(List<String> var1);

        public void onActivateResult(String var1);

        public void onLog(String var1);

        public void onActivateError(String var1);
    }
}

