/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.asm;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.orecruncher.dsurround.asm.TransformLoader;
import org.orecruncher.dsurround.asm.Transformer;
import org.orecruncher.dsurround.asm.Transmorgrifier;

public class PatchEntityArrow
extends Transmorgrifier {
    public PatchEntityArrow() {
        super("net.minecraft.entity.projectile.EntityArrow");
    }

    @Override
    public String name() {
        return "No Particles on Arrows";
    }

    @Override
    public boolean isEnabled() {
        return TransformLoader.enableArrowPatch;
    }

    @Override
    public boolean transmorgrify(ClassNode cn) {
        String[] sig = new String[]{"()V"};
        String[] names = new String[]{"onUpdate", "func_70071_h_", "B_"};
        MethodNode m = this.findMethod(cn, sig, names);
        if (m != null) {
            this.logMethod(Transformer.log(), m, "Found!");
            for (int i = 0; i < m.instructions.size(); ++i) {
                AbstractInsnNode node = m.instructions.get(i);
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode mn = (MethodInsnNode)node;
                if (!this.isOneOf(mn.desc, "()Z") || !this.isOneOf(mn.name, "getIsCritical", "func_70241_g", "n")) continue;
                m.instructions.set(mn.getPrevious(), (AbstractInsnNode)new InsnNode(0));
                m.instructions.set((AbstractInsnNode)mn, (AbstractInsnNode)new InsnNode(3));
                return true;
            }
        } else {
            Transformer.log().error("Unable to locate method {}{}", (Object)names[0], (Object)sig[0]);
        }
        Transformer.log().info("Unable to patch [{}]!", (Object)this.getClassName());
        return false;
    }
}

