#version 330
// uniform sampler2D textures[8];

uniform sampler2D grassTexture;
uniform sampler2D tintTexture;
uniform sampler2D overlayTexture;
uniform sampler2D overlayTextureB;

in vec2 fragTexCoord;
in vec2 fragTintCoord;
in float fogFactor;
in vec3 cameraToFragment;
in float overlayMod;
in vec4 worldPosition;
in vec3 local_light_pos;
in vec3 local_normal;
in vec3 fragNormal;
in vec4 frontColor;
out vec4 fragColor[3];
uniform mat4 worldToView;
uniform vec3 fogColor;
uniform float alpha;
in vec4 viewPosition;
uniform vec4 overlayBox[4]; // .xyzw == minX,minZ,maxX,maxZ
uniform vec4 overlayMap[4]; // .xyzw == +x,+z,*x,*z, to convert from overlay box coords to texture coords.
uniform int overlayCascades;

struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];


/////////////////////////////////////////////////////////////////////////////////
// The following are from https://www.shadertoy.com/view/4dS3Wd
float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }
float noise(float x) { float i = floor(x); float f = fract(x); float u = f * f * (3.0 - 2.0 * f); return mix(hash(i), hash(i + 1.0), u); }
float noise(vec2 x) { vec2 i = floor(x); vec2 f = fract(x); float a = hash(i); float b = hash(i + vec2(1.0, 0.0)); float c = hash(i + vec2(0.0, 1.0)); float d = hash(i + vec2(1.0, 1.0)); vec2 u = f * f * (3.0 - 2.0 * f); return mix(a, b, u.x) + (c - a) * u.y * (1.0 - u.x) + (d - b) * u.x * u.y; }
// float noise(vec3 x) { const vec3 step = vec3(110, 241, 171); vec3 i = floor(x); vec3 f = fract(x); float n = dot(i, step); vec3 u = f * f * (3.0 - 2.0 * f); return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x), mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y), mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x), mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z); }

float noise(vec3 p)
{
	const vec3 s = vec3(7, 157, 113);
	vec3 ip = floor(p); p -= ip;
	vec4 h = vec4(0,s.yz,s.y+s.z) + dot(ip, s);
	p = p*p*(3.0 - 2.0 * p);
	h = mix(fract(sin(h)*43758.5453), fract(sin(h+s.x)*43758.5453), p.x);
	h.xy = mix(h.xz, h.yw, p.y);
	return mix(h.x, h.y, p.z); // range [0 .. 1]

	// const vec3 step = vec3(110, 241, 171);
	// vec3 i = floor(x);
	// vec3 f = fract(x);
	// float n = dot(i, step);
	// vec3 u = f * f * (3.0 - 2.0 * f);
	// return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x), mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y), mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x), mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z);
}
#include "shade_h.glsl"
#include "shadow_h.glsl"

int calculateOverlayLevel()
{
	for ( int i = 0; i < overlayCascades; i++ )
	{
		float margin = 0.0;
		if ( overlayBox[i].x+margin < worldPosition.x &&
				overlayBox[i].y+margin < worldPosition.z &&
				overlayBox[i].z-margin > worldPosition.x &&
				overlayBox[i].w-margin > worldPosition.z )
		{
			return i;
		}
	}
	return -1;
}

vec2 calculateOverlayCoordinate(int level)
{
	{
		vec2 boxPos = vec2(
				(worldPosition.x - overlayBox[level].x) / (overlayBox[level].z - overlayBox[level].x),
				(worldPosition.z - overlayBox[level].y) / (overlayBox[level].w - overlayBox[level].y)
				);
		vec2 texCoord = (boxPos * overlayMap[level].zw) + overlayMap[level].xy;
		return texCoord;
	}
}

void main()
{
	vec4 color = frontColor;

	vec4 textureSample = texture(grassTexture, fragTexCoord);
	if ( textureSample.a < 0.5 )
		discard;
	vec4 tint = texture(tintTexture, fragTintCoord);
	int overlayLevel = calculateOverlayLevel();
	// vec4 overlay = texture(textures[2], overlayTexcoord.st);
	// color.a = diffuse.a;
	color.rgb = mix(color.rgb, tint.rgb, tint.a);
	vec4 overlayGlow = vec4(0,0,0,1);
	if ( overlayLevel >= 0 )
	{
		vec2 overlayTexcoord = calculateOverlayCoordinate(overlayLevel);

		vec4 overlay = texture(overlayTexture, vec2(overlayTexcoord.s, overlayTexcoord.t));
		overlayGlow = texture(overlayTextureB, overlayTexcoord.st);
		color.rgb = mix(color.rgb, overlay.rgb, overlay.a * overlayMod);
	}

	vec4 glowColor = vec4(0,0,0,color.a);
	glowColor = mix(glowColor, overlayGlow, 0.99);

	vec3 n = normalize(fragNormal);
	float rawNdotL = dot(n,lightSource[0].position);
	float illuminated = rawNdotL;

	if ( rawNdotL < 0.0 )
		illuminated = 0.0;
	illuminated = calculate_shadow_illumination( worldPosition, rawNdotL );

	vec3 N = normalize(local_normal);
    vec3 L = normalize(local_light_pos);
    vec3 V = normalize(-cameraToFragment);
    vec3 H = normalize(V + L);

	float specular = 0.0;
	float rimSpecular = 0.30;
	float roughness = 0.8;
	float specRoughness = 0.85;
	float subsurface = 0.0;
	float clearcoat = 0.0;
	vec3 linearColor;

	// color.rgb = shade(color.rgb, N,L,V,H, mix(0.2,1.0,illuminated), specular, rimSpecular, roughness, specRoughness);
	color.rgb = shade(color.rgb, linearColor, N,L,V,H,
			illuminated, specular, rimSpecular, roughness, specRoughness,
			subsurface, clearcoat, fogColor.rgb, 1.0 - fogFactor, true);
	// color.rgb = mix(fogColor.rgb, color.rgb, fogFactor );

	fragColor[0].rgb = color.rgb;
	fragColor[0].a = smoothstep(0.5, 0.55, textureSample.a) * alpha;
	fragColor[1].rgba = glowColor;
	// fragColor[2].rgba = vec4( vec3(N), 1.0);
	fragColor[2].rgba = vec4( vec3(0.0), 1.0);

	// float di = clamp( 100.0, length(cameraToFragment), 200.0 );
	// float d = mix( 2.0, 10.0, (di-100.0)/100.0 );
	// fragColor[2].rgba = d * vec4( vec3(N), 1.0);
}

