#version 330
uniform sampler2D key;
uniform sampler2D map[4];
uniform sampler2D height;
uniform sampler2D normal;

uniform sampler2D mountain;
uniform sampler2D beach;
uniform sampler2D mountainMask;
uniform sampler2D beachMask;
uniform sampler2D mountainHeight;

uniform vec3 origin;
uniform float texelSizeX;
uniform float texelSizeZ;
uniform float worldScale;

uniform float minHeight[6];
uniform float maxHeight[6];

out vec4 fragColor;

in vec4 worldPosition;

vec2 makeTexel(int i, float height, float slope)
{
	// BLEAH!  THESE TEXTURES SHOULD BE CLAMPED, INSTEAD OF THIS DODGY AVOIDING
	// OF THE EDGES!
	float y = clamp(
			(height - minHeight[i]) / (maxHeight[i] - minHeight[i]),
			0.0, 1.0);
			// 0.02,0.98);

	float x = clamp( slope, 0.0, 1.0);
	return vec2(x,y);
}

void main(void)
{
	vec2 keyTexel = (worldPosition.xz - origin.xz) / vec2(texelSizeX,texelSizeZ);

	vec4 key = texture(key, keyTexel);

	vec2 worldTexel = worldPosition.xz / worldScale;

	float mountainKey = texture(mountainMask, worldTexel).r;
	vec2 bk = texture(beachMask, worldTexel).ra;
	float beachKey = 1.0 - (bk.r * bk.g);
	beachKey = (3.f*beachKey*beachKey)-(2.f*beachKey*beachKey*beachKey);

	float h = texture(height, worldTexel).r;
	// if ( h < 0.0 )
	// 	h = 20.0;

	vec3 normal =  texture(normal, worldTexel).xyz;
	normal = (normal * 2.0) - vec3(1.0); // [0..1] -> [-1..1]
	float slope = normal.y;

	float mountainHeight = texture(mountainHeight, worldTexel * 2048.0).r;

	vec4 colorA = texture(map[0], makeTexel(0,h,slope));
	vec4 colorB = texture(map[1], makeTexel(1,h,slope));
	vec4 colorC = texture(map[2], makeTexel(2,h,slope));
	vec4 colorD = texture(map[3], makeTexel(3,h,slope));

	vec4 result = (colorA * key.r) +
		(colorB * key.g) +
		(colorC * key.b) +
		(colorD * key.a);

	vec4 colorBeach = texture(beach, makeTexel(5,h,slope));
	vec4 colorMtn = texture(mountain, makeTexel(4,mountainHeight,slope));

	// if ( h < 0.0 )
	// 	result = colorBeach;
	// if ( h > 1.0 && h < 2.0 )
	// 	result = vec4(1.0,0.0,0.0,0.0);
	// if ( h > 4.0 && h < 5.0 )
	// 	result = vec4(0.0,0.0,1.0,0.0);

	result = mix( result, colorBeach, beachKey );
	result = mix( result, colorMtn, mountainKey );

	// if ( isinf(result.r) || isnan(result.r) )
	// 	result = vec4(1.0);

	// result = mix( result, vec4(1.0,0.0,1.0,1.0), beachKey );

	// result = vec4(1.0,1.0,0.0,1.0);

	fragColor.rgba = result;
}



