#version 330
uniform bool fog;
uniform float fogDensity;
// uniform mat4 localToWorld;
in mat4 localToWorldAttrib;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
uniform vec4 universal_color;
uniform vec3 cameraPosition;

out float fogFactor;
in vec4 vertex;
in vec3 normal;
in vec4 color;
in vec2 texcoord;

out vec4 frontColor;
out vec3 halfVector;

out vec2 texcoord_out;

// out vec4 diffuse;
// out vec4 ambient;
out vec3 fragNormal;
// out vec3 lightDir;
// out vec3 halfVector;
//
struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
}; 

uniform lightSourceParameters lightSource[4];

void main(void)
{
	frontColor = color;
	vec4 worldPosition = localToWorldAttrib * vertex;
	gl_Position = viewToProjection * worldToView * worldPosition ;

	/* first transform the normal into world space and
	   normalize the result */
	fragNormal = normalize((localToWorldAttrib * vec4(normal,0.0)).xyz);

	vec3 viewDir = normalize(cameraPosition - worldPosition.xyz);
	texcoord_out = reflect( viewDir, fragNormal ).xy;

	halfVector = normalize( viewDir + lightSource[0].position );

	fogFactor = 1.0;
	if ( fog )
	{
		const float LOG2 = 1.442695;
		vec3 vVertex = vec3(gl_Position);
		float distance = length(vVertex);
		fogFactor = exp2( -fogDensity *
				fogDensity *
				distance *
				distance *
				LOG2 );
		fogFactor = clamp(fogFactor, 0.0, 1.0);
	}
}
