#version 330
#ifdef TEXTURE
uniform sampler2D textures[8];
uniform float alphaRef;
#endif // TEXTURE
in vec2 texcoord_out;

uniform float fogDensity;
uniform bool fog;
in vec3 cameraToFragment;
uniform vec3 fogColor;
uniform bool glow;
uniform float globalTime;
uniform float fade;
uniform bool discard_bits;

#ifdef LIT
struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];
in vec3 fragNormal;
#endif // LIT

in vec4 frontColor;
out vec4 fragColor[2];

in vec4 worldPosition;

void main(void)
{
	vec4 color = frontColor;
#ifdef TEXTURE
	vec4 textureSample = texture(textures[0], texcoord_out.st);
	if ( textureSample.a < alphaRef )
		discard;
	color *= textureSample;
#endif // TEXTURE

	if ( discard_bits )
	{
		float seq = texcoord_out.y;//mod(texcoord_out.x,1.0);
		float minTime = mod(0.3 * globalTime,1.0);
		// our "minTime" now goes from [0..1] over about 3 seconds.  We want to remove
		// a moving section from the middle.  SO, the space we want to remove from
		// the current point is (let's say) 1.0.
		float timeToRemove = 0.3;
		//
		// this means that we need to adjust our time to extend this amount time
		// BEFORE and AFTER to [0..1] range.

		float maxTime = mod(minTime + timeToRemove,1.0);
		if ( maxTime < minTime )
		{
			if ( seq < maxTime || seq > minTime )
				discard;
		}
		else
		{
			if ( seq > minTime && seq < maxTime )
				discard;
		}
	}

#ifdef LIT
	vec3 n = normalize(fragNormal);
	float NdotL = max(dot(n,lightSource[0].position)+1.0,0.0) * 0.5;

	if ( NdotL < 0.4 )
		NdotL = 0.2;

	vec4 ambientPart = color * lightSource[0].ambient;
	vec4 diffusePart = color * lightSource[0].diffuse * NdotL;
	color = ambientPart + diffusePart;
#endif // LIT

	vec3 finalColor = color.rgb;
	if ( fog )
	{
		float fragmentDistance = length(cameraToFragment) / 100.0;
		const float LOG2 = 1.442695;
		float fogFactor = exp2( -fogDensity *
				fogDensity *
				fragmentDistance *
				fragmentDistance *
				LOG2 );
		fogFactor = clamp(fogFactor, 0.0, 1.0);
		finalColor = mix(fogColor.rgb, color.rgb, fogFactor );
	}
	vec3 glowColor = vec3(0.0);
	if ( glow )
		glowColor = finalColor;


	fragColor[0].rgba = vec4(finalColor, color.a * fade);
	fragColor[1].rgba = vec4(glowColor, color.a * fade);
	// fragColor = vec4(1.0,0.0,0.0,1.0);
}


