#version 330
uniform bool glow;
uniform vec4 flatColor;

in vec4 frontColor;
out vec4 fragColor[2];

in vec4 worldPosition;
#include "rez2DXZ_h.glsl"

void main(void)
{
	vec4 color = frontColor * flatColor;
	vec3 glowColor = vec3(0.0);
	if ( glow )
		glowColor = color.rgb;

	vec4 nowGlow = vec4(glowColor, color.a);
	vec4 finalColor;
	vec4 finalGlow;
	rez2D( worldPosition, color, nowGlow, finalColor, finalGlow );

	fragColor[0].rgba = finalColor;
	fragColor[1].rgba = finalGlow;//vec4(glowColor, color.a);
}


