#version 330
uniform mat4 localToWorld;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
uniform vec4 universal_color;

in vec4 vertex;
in vec4 color;
out vec4 frontColor;
#ifdef TEXTURE
in vec2 texcoord;
out vec2 texcoord_out;
#endif // TEXTURE

void main()
{
	frontColor = color * universal_color;
	gl_Position = viewToProjection * worldToView * localToWorld * vertex;

#ifdef TEXTURE
	texcoord_out = texcoord;
#endif // TEXTURE
}

