#version 330
#ifdef TEXTURE
uniform sampler2D textures[8];
in vec2 texcoord_out;
uniform float alphaRef;
#endif // TEXTURE

uniform float fade = 0.0;
in vec3 cameraToFragment;
uniform bool glow;
uniform float glowFactor;
uniform vec4 tint;

in vec4 frontColor;
out vec4 fragColor[3];

in vec4 worldPosition;

#include "rez2D_h.glsl"

void main(void)
{
	vec4 color = frontColor;
#ifdef TEXTURE
	vec4 textureSample = texture(textures[0], texcoord_out.st);
	if ( textureSample.a < alphaRef )
		discard;
	color *= textureSample;
#endif // TEXTURE

	color.rgb = mix( color.rgb, tint.rgb, tint.a );
	color.a *= (1.0-fade);

	vec4 glowColor = vec4(vec3(0.0),color.a);
	if ( glow )
	{
		glowColor = color;
		glowColor.rgb *= 0.5;
	}

	fragColor[2].rgba = vec4(0.0);

	vec4 finalColor;
	vec4 finalGlow;
	rez2D( worldPosition, color, glowColor, finalColor, finalGlow );

	fragColor[0].rgba = finalColor;
	fragColor[1].rgba = finalGlow;
}


