#version 330
in vec2 texcoord_out;

in vec3 cameraToFragment;
uniform bool rezEffect;
uniform float rezTime;
uniform bool glow;
// uniform float globalTime;
// uniform float fadeDistance;
// uniform float alphaDistance;

in vec4 frontColor;
out vec4 fragColor[2];

in vec4 worldPosition;

void main(void)
{
	vec4 color = frontColor;
	vec3 finalColor = color.rgb;
	vec3 glowColor = vec3(0.0);
	if ( glow )
		glowColor = finalColor;

	if ( rezEffect )
	{
		float totalDistance = 600.0; // sure, why not?
		float alphaDistance = 300.0; // mmmmkay
		float fadeDistance = 300.0; // mmmmkay
		// float fadeDuration = 10.0; // for right now
		float totalDuration = texcoord_out.y;
		float rezSpeed = totalDistance / totalDuration;
		// float totalDistance = texcoord_out.y;//(repeatAfter*rezSpeed)-fadeDistance;
		// float totalDuration = totalDistance + fadeDistance;
		// float rezSpeed = 1.0 * (totalDistance + fadeDistance) / totalDuration;

		float wrapDuration = (totalDistance + fadeDistance) / rezSpeed;
		float time = mod( rezTime, wrapDuration );

		float rezzedSoFar = time * rezSpeed;
		float distanceHere = (texcoord_out.x/texcoord_out.y) * totalDistance;

		if ( rezzedSoFar < distanceHere )
			discard;

		float distanceSinceRez = rezzedSoFar - distanceHere;
		if ( distanceSinceRez > alphaDistance )
			discard;
		else
		{
			color.a *= 1.0 - (distanceSinceRez / alphaDistance);
		}
		if ( distanceSinceRez < fadeDistance )
		{
			// float bright = smoothstep( fadeDistance, 0.0, distanceSinceRez );
			float bright = 1.0 - (distanceSinceRez / fadeDistance);
			bright *= bright;
			fragColor[0].rgba = vec4(finalColor, color.a);
			fragColor[1].rgba = vec4(0.05,0.5,1.0, color.a * bright);
			return;
		}
	}

	// fragColor[0].rgba = vec4(finalColor, color.a);
	fragColor[0].rgba = vec4(finalColor, color.a);
	// fragColor[0].r = texcoord_out.x / 0.5;
	fragColor[1].rgba = vec4(glowColor, color.a);
	// fragColor = vec4(1.0,0.0,0.0,1.0);
	// fragColor[0].rgba = mix(vec4(1,0,0,1),vec4(finalColor, color.a),0.01);
}




