#version 330
uniform sampler2D key;
uniform sampler2D map;
uniform float texelSize;

out vec4 fragColor;

in vec4 worldPosition;

void main(void)
{
	vec2 keyTexel = worldPosition.xz / texelSize;
	vec4 keySample = texture(key, keyTexel);

	// 8 for the pixel separation, 256 because that's how frequently the texture repeats.
	vec2 worldTexel = worldPosition.xz / 2048.0;
	float height = texture(map, worldTexel).r;

	float alpha = keySample.r * keySample.a;


	// HACK FOR VISIBILITY IN EXPORTED FILES:  TO REMOVE BEFORE USING THIS FOR REAL!
	// height = height / 400.0;

	fragColor.rgba = vec4(vec3(height), alpha);
}

