#version 330
in mat4 localToWorldAttrib;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
uniform vec4 universal_color;

in vec4 vertex;
in vec4 color;
in vec2 texcoord;
out vec4 frontColor;
out vec2 texcoord_out;
out vec4 worldPosition;

void main()
{
	frontColor = color * universal_color;
	gl_Position = viewToProjection * worldToView * localToWorldAttrib * vertex;
	worldPosition = localToWorldAttrib * vertex;

	texcoord_out = texcoord.xy;
}


