#version 330
uniform bool fog;
uniform float fogDensity;
// uniform mat4 localToWorld;
in mat4 localToWorldAttrib;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
in vec4 instanceColorAttrib;

uniform vec4 universal_color;

out vec3 cameraToFragment;
in vec4 vertex;
in vec3 normal;
in vec2 texcoord;

out vec4 frontColor;
out vec4 worldPosition;
out vec4 localPosition;

#ifdef TEXTURE
out vec2 texcoord_out;
#endif

void main(void)
{
#ifdef TEXTURE
	texcoord_out = texcoord;
#endif // TEXTURE

	frontColor = instanceColorAttrib * universal_color;
	localPosition = vertex;
	worldPosition = localToWorldAttrib * vertex;
	gl_Position = viewToProjection * worldToView * worldPosition;

	cameraToFragment = vec3(gl_Position);
}

