#version 330
uniform sampler2D textures[8];
uniform float worldScale;
in vec4 worldPosition;
in vec2 texcoord_out;
out vec4 fragColor;

uniform vec3 start;
uniform vec3 end;
uniform float innerRadius;
uniform float outerRadius;

void main(void)
{
	vec2 startTexel = start.xz / worldScale;
	vec2 endTexel = end.xz / worldScale;
	float startHeight = texture( textures[0],  startTexel ).r;
	float endHeight = texture( textures[0],  endTexel ).r;

	vec2 startToEnd = end.xz - start.xz;
	float startToEndLength = length(startToEnd);
	startToEnd /= startToEndLength;
	vec2 startToPosition = worldPosition.xz - start.xz;
	float proj = clamp( dot(startToEnd, startToPosition), 0.0, startToEndLength );
	float projFraction = proj / startToEndLength;

	float heightHere = mix( startHeight, endHeight, projFraction );

	// texcoord_out.x 0..1 is left to right across this path.

	vec2 positionOnLine = start.xz + (proj * startToEnd);
	float distanceFromLine = length(positionOnLine - worldPosition.xz);

	// float mask = smoothstep( outerRadius, innerRadius, distanceFromLine );
	float mask = (distanceFromLine - innerRadius) / (outerRadius - innerRadius);
	mask = 1.0 - clamp( mask, 0.0, 1.0 );
	mask = (3.0 * mask * mask) - (2.0 * mask * mask * mask);

	fragColor = vec4( vec3(heightHere), mask );
}






