#version 330
uniform mat4 localToWorld;
uniform mat4 worldToView;
uniform mat4 viewToProjection;

uniform vec4 baseColor;
in vec4 vertex;
out vec4 frontColor;
in vec2 texcoord;
out vec2 texcoord_out;

void main()
{
	frontColor = baseColor;
	gl_Position = viewToProjection * worldToView * localToWorld * vertex;

	texcoord_out = texcoord;
}


