#version 330
#ifdef TEXTURE
uniform sampler2D diffuse;
in vec2 texcoord_out;
uniform float alphaRef;
#endif // TEXTURE

// in float fogFactor;
uniform float fogDensity;
uniform float ssao_size;
uniform bool fog;
in vec3 cameraToFragment;
// in float fragmentDistance;
uniform vec3 fogColor;
uniform float glow;
uniform mat4 worldToView;
in vec4 viewPosition;
in vec3 local_light_pos;
in vec3 local_normal;


#ifdef LIT
struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];
in vec3 fragNormal;
#endif // LIT

in vec4 frontColor;
out vec4 fragColor[3];

in vec4 worldPosition;


#include "rez3D_h.glsl"
#ifdef LIT
#include "shade_h.glsl"
#include "shadow_h.glsl"
#endif // LIT

float noise(vec2 p, float time)
{
	return sin(p.x*10.) * sin(p.y*(3. + sin(time/11.))) + .2;
}

mat2 rotate(float angle)
{
	return mat2(cos(angle), -sin(angle), sin(angle), cos(angle));
}


float fbm(vec2 p, float time)
{
	float f = 0.;
	float amp = .5;
	for( int i = 0; i < 3; i++) {
		mat2 modify = rotate(time/50. * float(i*i));
		f += amp*noise(p, time);
		p = modify * p;
		p *= 2.;
		amp /= 2.2;
	}
	return f;
}

float pattern(vec2 p, out vec2 q, out vec2 r, float time) {
	q = vec2( fbm(p + vec2(1.), time),
			fbm(rotate(.1*time)*p + vec2(3.), time));
	r = vec2( fbm(rotate(.2)*q + vec2(0.), time),
			fbm(q + vec2(0.), time));
	return fbm(p + 1.0*r, time);
}

float swirl( vec2 fragCoord, float time )
{
	vec2 p = fragCoord.xy * 0.001;
	p *= 3.0;
	p.y -= time * 0.002;
	vec2 q;
	vec2 r;
	float f = pattern(p, q, r, time);
	return f;
}

void main(void)
{
	// fragColor = vec4(1.0,0.0,0.0,1.0);
	vec4 color = frontColor;

	// color.rgb = vec3(0.31,0.1,0.3);
#ifdef TEXTURE
	vec4 textureSample = texture(diffuse, texcoord_out.st);
	if ( textureSample.a < alphaRef )
		discard;
	color *= textureSample;
#endif // TEXTURE

	float fogFactor = 1.0;
	if ( fog )
	{
		float fragmentDistance = length(cameraToFragment);
		const float LOG2 = 1.442695;
		fogFactor = exp2( -fogDensity *
				fogDensity *
				fragmentDistance *
				fragmentDistance *
				LOG2 );
		fogFactor = clamp(fogFactor, 0.0, 1.0);
		// finalColor = mix(fogColor.rgb, color.rgb, fogFactor );
	}
#ifdef LIT
	vec3 n = normalize(fragNormal);
	float rawNdotL = dot(n,lightSource[0].position);
	float illuminated = calculate_shadow_illumination(worldPosition, rawNdotL);// * max(rawNdotL,0.0);//max(rawNdotL+1.0,0.0) * 0.5;

	vec3 N = normalize(local_normal);
	vec3 L = normalize(local_light_pos);
	vec3 V = normalize(-cameraToFragment);
	vec3 H = normalize(L + V);
	float specular = 0;//min( length(color.rgb), 0.11 );
	float rimSpecular = 0.0;//30;
	float roughness = 0.0;
	float subsurface = 0.0;
	vec3 linearColor;
	color.rgb = shade(color.rgb, linearColor, N,L,V,H,
			illuminated, specular, rimSpecular, roughness, roughness, subsurface, 1.0,
			fogColor.rgb, 1.0 - fogFactor, true);

#else // !LIT
	color.rgb = mix(fogColor.rgb, color.rgb, fogFactor );
#endif

	vec4 finalColor;
	vec4 finalGlow;
	float glow_mine = 0.3;
	rez3D( color, glow_mine, finalColor, finalGlow );

	fragColor[0].rgba = finalColor;
	fragColor[1].rgba = finalGlow;

#ifdef LIT
	// vec3 dx = dFdx( cameraToFragment );
	// vec3 dy = dFdy( cameraToFragment );
	// vec3 triangleN = -normalize(cross(dx,dy));

	// assume ssao_size is [0.1-5.0]
	vec3 mungedN =  0.5 * ((N * (ssao_size/5.0)) + vec3(1.0));
	fragColor[2].rgba = vec4( mungedN, 1.0);

	// fragColor[2].rgba = vec4( ssao_size * vec3(N), 1.0);
#else
	fragColor[2].rgba = vec4(0,0,0,1);
#endif // LIT
}



