uniform bool rezEffect;
uniform bool rezBroken;
uniform float rezTime;
uniform float rezBrokenTime;
uniform float rezGridDims;
uniform float rezDelayPerGridX;
uniform float rezDelayPerGridY;
uniform vec3 rezOrigin;
uniform float rezExpandTime;
uniform float rezFadeTime;
uniform float rezRandomExtraDelay;

/////////////////////////////////////////////////////////////////////////////////
// The following are from https://www.shadertoy.com/view/4dS3Wd
float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }
float noise(float x) { float i = floor(x); float f = fract(x); float u = f * f * (3.0 - 2.0 * f); return mix(hash(i), hash(i + 1.0), u); }
float noise(vec2 x) { vec2 i = floor(x); vec2 f = fract(x); float a = hash(i); float b = hash(i + vec2(1.0, 0.0)); float c = hash(i + vec2(0.0, 1.0)); float d = hash(i + vec2(1.0, 1.0)); vec2 u = f * f * (3.0 - 2.0 * f); return mix(a, b, u.x) + (c - a) * u.y * (1.0 - u.x) + (d - b) * u.x * u.y; }
// float noise(vec3 x) { const vec3 step = vec3(110, 241, 171); vec3 i = floor(x); vec3 f = fract(x); float n = dot(i, step); vec3 u = f * f * (3.0 - 2.0 * f); return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x), mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y), mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x), mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z); }
float noise(vec3 p)
{
	const vec3 s = vec3(7, 157, 113);
	vec3 ip = floor(p); p -= ip;
	vec4 h = vec4(0,s.yz,s.y+s.z) + dot(ip, s);
	p = p*p*(3.0 - 2.0 * p);
	h = mix(fract(sin(h)*43758.5453), fract(sin(h+s.x)*43758.5453), p.x);
	h.xy = mix(h.xz, h.yw, p.y);
	return mix(h.x, h.y, p.z); // range [0 .. 1]

	// const vec3 step = vec3(110, 241, 171);
	// vec3 i = floor(x);
	// vec3 f = fract(x);
	// float n = dot(i, step);
	// vec3 u = f * f * (3.0 - 2.0 * f);
	// return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x), mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y), mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x), mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z);
}

void rez3D_glowcolor( in vec4 color, in vec4 glowColor, out vec4 outcolor, out vec4 outglow )
{
	outcolor = color;
	outglow = glowColor;
	if ( rezEffect || rezBroken )
	{
		float time = rezTime;
		/* float time = mod(globalTime,20.0); */

		float gridDims = rezGridDims;
		float halfGridDims = gridDims * 0.5;
		vec3 relativePosition = worldPosition.xyz - rezOrigin;

		int xGridSquare = int(floor(relativePosition.x / gridDims));
		int yGridSquare = int(floor(relativePosition.y / gridDims));
		int zGridSquare = int(floor(relativePosition.z / gridDims));
		float xGridPos = relativePosition.x - xGridSquare*gridDims;
		float yGridPos = relativePosition.y - yGridSquare*gridDims;
		float zGridPos = relativePosition.z - zGridSquare*gridDims;

		float distanceFromGridEdge = min( min( xGridPos, yGridPos ), zGridPos);
		/* distanceFromGridEdge = min( distanceFromGridEdge, xGridPos ); */
		/* distanceFromGridEdge = min( distanceFromGridEdge, yGridPos ); */
		/* distanceFromGridEdge = min( distanceFromGridEdge, zGridPos ); */
		distanceFromGridEdge = min( distanceFromGridEdge, gridDims - xGridPos );
		distanceFromGridEdge = min( distanceFromGridEdge, gridDims - yGridPos );
		distanceFromGridEdge = min( distanceFromGridEdge, gridDims - zGridPos );
		distanceFromGridEdge = distanceFromGridEdge / halfGridDims; // [0..1] for 'grid edge' to 'center'

		float extraDelay = noise( vec3(xGridSquare,yGridSquare, zGridSquare) );
		extraDelay *= extraDelay * extraDelay;
		extraDelay *= rezRandomExtraDelay;

		// effect moves across the ground from -x to +x and -y to +y.
		float delay = (rezDelayPerGridX * xGridSquare) + (rezDelayPerGridY * yGridSquare) + extraDelay;

		float delta = time - delay;

		vec3 rezColor = vec3(0.0,1.0,1.0);

		if ( rezBroken )
		{
			float brokenDelta = rezBrokenTime - delay;
			rezColor = vec3(1.0, 0.5, 0.5);
			outcolor = color;
			// outcolor.rgb = vec3(0.1);
			outglow = glowColor;
			if ( brokenDelta > rezExpandTime && brokenDelta < rezFadeTime )
			{
				float f = smoothstep( rezExpandTime, rezFadeTime, brokenDelta );
				f += 0.1;
				outglow.rgb = 0.5 * f * vec3(1.0 - color.rgb) * vec3(1.0,0.5,0.5);
				outcolor.rgb += outglow.rgb;
			}
			// return;
		}

		if ( rezEffect )
		{
			// display grid structure.
			// fragColor[0].rgba = vec4(vec3(distanceFromGridEdge),1.0);
			// fragColor[1].rgba = vec4(0.0,0.0,0.0,1.0);
			// return;

			if ( delta < 0 )
				discard;
			if ( delta < rezExpandTime )
			{
				float f = delta / rezExpandTime;
				// float f = smoothstep( 0.0, rezExpandTime, delta );
				// f = 3.0 * f * f - 2.0 * f * f * f;
				if ( distanceFromGridEdge > f )
					discard;

				outcolor.rgba = vec4(color.rgb,color.a * f);
				outglow.rgba = vec4(rezColor, 0.5 * color.a * f);
				return;
			}
			else if ( delta < rezFadeTime )
			{
				float thisPhaseTime = delta - rezExpandTime;
				thisPhaseTime = thisPhaseTime / (rezFadeTime - rezExpandTime);
				float f = thisPhaseTime;
				f = 3.0 * f * f - 2.0 * f * f * f;
				float distanceFromCenter = 1.0 - distanceFromGridEdge;
				if ( distanceFromCenter > f )
				{
					// this is buggy;  we should use the * glow or else things go
					// super-bright as we switch into the fade...
					//
					// But it actually makes a really interesting "flash" during the rez
					// effect.  So maybe leave it like this?  (Or make the "flash" happen
					// intentionally, and in a more tunable way, rather than leaving the bug in place?)
					outglow.rgba = mix(vec4(rezColor,color.a*0.5), vec4(color.rgb, color.a), f);
					// fragColor[1].rgba = mix(vec4(0.0,1.0,1.0,color.a*0.5), vec4(color.rgb * glow, color.a), f);
				}
				else
				{
					outglow.rgba = glowColor;
				}
				outcolor.rgba = color;
				return;
			}
		}
	}
}

void rez3D( in vec4 color, in float glow, out vec4 outcolor, out vec4 outglow )
{
	vec4 glowColor = vec4(color.rgb*glow, color.a);
	rez3D_glowcolor( color, glowColor, outcolor, outglow );
}


