#version 330
#ifdef TEXTURE
uniform sampler2D textures[8];
in vec2 texcoord_out;
uniform float alphaRef;
#endif // TEXTURE

// in float fogFactor;
uniform float fogDensity;
uniform bool fog;
in vec3 cameraToFragment;
// in float fragmentDistance;
uniform vec3 fogColor;
uniform bool rezEffect;
uniform float rezTime;
uniform float rezGridDims;
uniform float rezDelayPerGrid;
uniform float rezOriginX;
uniform float rezOriginY;
uniform float rezExpandTime;
uniform float rezFadeTime;
uniform float rezRandomExtraDelay;
uniform bool rezReverse;
uniform bool glow;

#ifdef LIT
struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];
in vec3 fragNormal;
#endif // LIT

in vec4 frontColor;
out vec4 fragColor[2];

in vec4 worldPosition;

/////////////////////////////////////////////////////////////////////////////////
// The following are from https://www.shadertoy.com/view/4dS3Wd
float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }
float noise(float x) { float i = floor(x); float f = fract(x); float u = f * f * (3.0 - 2.0 * f); return mix(hash(i), hash(i + 1.0), u); }
float noise(vec2 x) { vec2 i = floor(x); vec2 f = fract(x); float a = hash(i); float b = hash(i + vec2(1.0, 0.0)); float c = hash(i + vec2(0.0, 1.0)); float d = hash(i + vec2(1.0, 1.0)); vec2 u = f * f * (3.0 - 2.0 * f); return mix(a, b, u.x) + (c - a) * u.y * (1.0 - u.x) + (d - b) * u.x * u.y; }
float noise(vec3 x) { const vec3 step = vec3(110, 241, 171); vec3 i = floor(x); vec3 f = fract(x); float n = dot(i, step); vec3 u = f * f * (3.0 - 2.0 * f); return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x), mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y), mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x), mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z); }

void main(void)
{
	vec4 color = frontColor;
#ifdef TEXTURE
	vec4 textureSample = texture(textures[0], texcoord_out.st);
	float a = smoothstep(0.1,0.6,textureSample.r);
	if ( a <= 0.0 )
		discard;
	color.a = a;
#endif // TEXTURE

#ifdef LIT
	vec3 n = normalize(fragNormal);
	float NdotL = max(dot(n,lightSource[0].position)+1.0,0.0) * 0.5;

	if ( NdotL < 0.4 )
		NdotL = 0.2;

	vec4 ambientPart = color * lightSource[0].ambient;
	vec4 diffusePart = color * lightSource[0].diffuse * NdotL;
	color = ambientPart + diffusePart;
#endif // LIT

	vec3 finalColor = color.rgb;
	if ( fog )
	{
		float fragmentDistance = length(cameraToFragment);
		const float LOG2 = 1.442695;
		float fogFactor = exp2( -fogDensity *
				fogDensity *
				fragmentDistance *
				fragmentDistance *
				LOG2 );
		fogFactor = clamp(fogFactor,0.0,1.0);
		finalColor = mix(fogColor.rgb, color.rgb, fogFactor );
	}
	vec3 glowColor = vec3(0.0);
	if ( glow )
		glowColor = finalColor;

	if ( rezEffect )
	{
		float time = rezTime;//mod(rezTime,15.0);

		float gridDims = rezGridDims;
		float delayPerGrid = rezDelayPerGrid;
		float halfGridDims = gridDims * 0.5;
		vec2 relativePosition = worldPosition.xy - vec2(rezOriginX, rezOriginY);
		float expandTime = rezExpandTime;

		if ( rezReverse )
		{
			relativePosition.y *= -1.0;
			/* delayPerGrid = 0.0; */
			/* expandTime = rezFadeTime * 0.5; */
		}
		float xGridSquare = floor(relativePosition.x / gridDims);
		float yGridSquare = floor(relativePosition.y / gridDims);
		float xGridPos = relativePosition.x - xGridSquare*gridDims;
		float yGridPos = relativePosition.y - yGridSquare*gridDims;

		float distanceFromGridEdge = min( xGridPos, yGridPos );
		distanceFromGridEdge = min( distanceFromGridEdge, gridDims - xGridPos );
		distanceFromGridEdge = min( distanceFromGridEdge, gridDims - yGridPos );
		distanceFromGridEdge = distanceFromGridEdge / halfGridDims; // [0..1] for 'grid edge' to 'center'

		// effect moves across the ground from +y to -y
		float extraDelay = noise( vec2(xGridSquare,yGridSquare) );
		extraDelay *= extraDelay * extraDelay;
		if ( rezReverse )
			extraDelay = 1.0 - extraDelay;
		//extraDelay *= extraDelay * extraDelay;
		extraDelay *= rezRandomExtraDelay;

		float delay = (delayPerGrid * yGridSquare) + extraDelay;

		float delta = time - delay;

		if ( delta < 0 )
			discard;

		float rez_brightness = 0.3;

		if ( delta < expandTime )
		{
			float f = delta * (1.0 / expandTime);
			if ( distanceFromGridEdge > f )
				discard;

			/* fragColor[0].rgba = vec4(finalColor.rgb,color.a * f); */
			fragColor[0].rgba = vec4(0.0,0.0,0.0,color.a * f);
			/* fragColor[1].rgba = vec4(0.0,0.0,0.0,color.a * f); */
			fragColor[1].rgba = vec4(0.0, 1.0, 1.0, rez_brightness * color.a * f);
			return;
		}
		else if ( delta < rezFadeTime )
		{
			float thisPhaseTime = delta - expandTime;
			thisPhaseTime = thisPhaseTime / (rezFadeTime - expandTime);
			float f = thisPhaseTime;
			float distanceFromCenter = 1.0 - distanceFromGridEdge;
			if ( distanceFromCenter > f )
			{
				/* fragColor[1].rgba = vec4(0.0, 1.0-f, 1.0-f, color.a * 0.5 * (1.0-f)); */
				fragColor[0].rgba = mix(vec4(0.0,0.0,0.0,color.a), vec4(finalColor.rgb,color.a), f);
				/* fragColor[1].rgba = vec4(0.0,0.0,0.0,color.a * f); */
				fragColor[1].rgba = mix(vec4(0.0,1.0,1.0,color.a*rez_brightness), vec4(glowColor, color.a), f);
			}
			else
			{
				fragColor[0].rgba = vec4(finalColor.rgb,color.a);
				fragColor[1].rgba = vec4(glowColor, color.a);
				/* fragColor[1].rgba = vec4(1.0,0.0,0.0, color.a); */
			}
			/* fragColor[0].rgba = vec4(finalColor.rgb,color.a); */
			return;
		}
	}

	fragColor[0].rgba = vec4(finalColor, color.a);
	fragColor[1].rgba = vec4(glowColor, color.a);
	// fragColor = vec4(1.0,0.0,0.0,1.0);
}


