#version 330
uniform sampler2D textures[8];
uniform vec3 offsets[2];
uniform float coefficients[3];

out vec4 fragColor;

in vec4 worldPosition;
in vec2 texcoord_out;

void main(void)
{
	vec4 result  = texture(textures[0], texcoord_out - offsets[1].st) * coefficients[0];
	     result += texture(textures[0], texcoord_out - offsets[0].st) * coefficients[1];
	     result += texture(textures[0], texcoord_out                ) * coefficients[2];
	     result += texture(textures[0], texcoord_out + offsets[0].st) * coefficients[1];
	     result += texture(textures[0], texcoord_out + offsets[1].st) * coefficients[0];

	result = normalize(result);

	fragColor.rgba = result;
}



