#version 330
uniform sampler2D textures[8];
in vec2 texcoord_out;
uniform float alphaRef;
uniform float zFar;
uniform float zNear;
uniform vec4 ssaoAmbientColor;
uniform float aspectRatio;

out vec4 fragColor[2];

in vec4 worldPosition;
in vec3 cameraToFragment;

/////////////////////////////////////////////////////////////////////////////////
// The following are from https://www.shadertoy.com/view/4dS3Wd
float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }
float noise(float x) { float i = floor(x); float f = fract(x); float u = f * f * (3.0 - 2.0 * f); return mix(hash(i), hash(i + 1.0), u); }
float noise(vec2 x) { vec2 i = floor(x); vec2 f = fract(x); float a = hash(i); float b = hash(i + vec2(1.0, 0.0)); float c = hash(i + vec2(0.0, 1.0)); float d = hash(i + vec2(1.0, 1.0)); vec2 u = f * f * (3.0 - 2.0 * f); return mix(a, b, u.x) + (c - a) * u.y * (1.0 - u.x) + (d - b) * u.x * u.y; }
float noise(vec3 x) { const vec3 step = vec3(110, 241, 171); vec3 i = floor(x); vec3 f = fract(x); float n = dot(i, step); vec3 u = f * f * (3.0 - 2.0 * f); return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x), mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y), mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x), mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z); }

float linearDepth(float z)
{
	float Z = zFar * zNear / (zFar - z*(zFar-zNear));
	return Z;
}

vec3 getPosition( vec2 where )
{
	// Okay.  Need to convert from 'where' to
	vec3 result;
	// result.z = linearDepth( texture(textures[0], where).r );
	result.z = linearDepth( texture(textures[0], where).r );
	result.x = ((where.x * aspectRatio)-(0.5 * aspectRatio)) * result.z;
	result.y = ((where.y)-0.5) * result.z;
	return result;
}

vec2 getRandom(in vec2 uv)
{
	vec2 result = texture(textures[1], uv).rb;
	// vec2 result = vec2(noise(uv.x), noise(uv.y));
	// result = result * 2.0 - vec2(1.0);
	result = normalize(result);
	return result;
}

// float g_sample_radius = 1.0;
float g_scale = 1.00;
float g_bias = 0.1;
float g_intensity = 2.0;

float doAmbientOcclusion(vec2 tcoord, vec2 uv, vec3 p, vec3 normal)
{
	vec3 diff = getPosition(tcoord + uv) - p;
	vec3 v = normalize(diff);
	float d = length(diff) * g_scale;
	float NdV = dot(normal,v) - (g_bias);
	float intensity = g_intensity / (1.0 + d); // intensity goes down as world-distance between point + sample goes up.

	// return max(0, NdV * intensity);
	return clamp( NdV * intensity, 0, 1.0 );
}

void main(void)
{
	// float worldDepth = getDepthAt(texcoord_out);

	vec2 texcoord = texcoord_out;
	vec3 position = getPosition(texcoord.st);
	vec3 normal = (texture(textures[2], texcoord.st).rgb);// * 2.0) - vec3(1.0);
	if ( length(normal) < 0.00001 )
		discard;
	// de-munge normal:
	normal = ((normal * 2.0) - vec3(1.0));
	normal *= 10.0;

	float ao = 0.0;
	float sample_radius = length(normal);
	// g_sample_radius = sample_radius;

	g_bias = mix(0.1, 0.5, sample_radius / 10.0);

	g_scale = min(1.0, 1.0 / sample_radius);
	if ( sample_radius > 0.0 )
	{
		normal = normalize(normal);
		// vec3 normal = texture(textures[2], texcoord.st).rgb;
		// vec3 position = vec3(texcoord.st, worldDepth);
		vec2 rand = getRandom(texcoord.st * 1000.0);

		float radius = sample_radius / position.z;

		const vec2 vec[4] = vec2[](
				vec2(1,0),
				vec2(-1,0),
				vec2(0,1),
				vec2(0,-1)
				);
		// const vec2 vec[16] = vec2[](vec2(0.53812504, 0.18565957), vec2(0.13790712, 0.24864247), vec2(0.33715037, 0.56794053), vec2(-0.6999805, -0.04511441), vec2(0.06896307, -0.15983082), vec2(0.056099437, 0.006954967), vec2(-0.014653638, 0.14027752), vec2(0.010019933, -0.1924225), vec2(-0.35775623, -0.5301969), vec2(-0.3169221, 0.106360726), vec2(0.010350345, -0.58698344), vec2(-0.08972908, -0.49408212), vec2(0.7119986, -0.0154690035), vec2(-0.053382345, 0.059675813), vec2(0.035267662, -0.063188605), vec2(-0.47761092, 0.2847911));

		int iterations = 4;
		// int octaves = 0;
		int octaves = 4;
		radius *= 1.0;
		for ( int j = 0; j < iterations; j++ )
		{
			float factor = 1.0;
			vec2 coord1 = reflect( vec[j], rand ) * radius;

			for ( int s = 0; s < octaves; s++ )
			// while( length(coord1) > 0.001 )
			{
				vec2 coord2 = 0.75 * vec2( coord1.x*0.707 - coord1.y * 0.707,
						coord1.x*0.707 + coord1.y*0.707);

				ao += doAmbientOcclusion(texcoord,coord1, position, normal);
				ao += doAmbientOcclusion(texcoord,coord2 * 0.75, position, normal);

				// ao += doAmbientOcclusion(texcoord,coord1 * 0.5, position, normal);
				// ao += doAmbientOcclusion(texcoord,coord2 * 0.25, position, normal);

				coord1 *= 0.5;
				// octaves++;
			}
		}
		ao /= float(octaves * iterations) * 2.0;
		// ao = rand.x;
	}
	// float myDepth = linearDepth(myDepthTex);
	// float min_depth_delta = 0.0;
	// float max_depth_delta = 300.0;
	// float f = myDepth - worldDepth;
	// f = 1.0 - smoothstep(min_depth_delta, max_depth_delta, f);
	// f = f * f;
	// f = f * fade * fade;
	// color.a *= f;
	// glow.a *= f;

	// ao *= 2.0;

	// fragColor[0] = vec4(0,0,0,0);
	// fragColor[0] = vec4(1,1,1,ao);
	fragColor[0] = vec4(0,0,0,ao);
	// fragColor[0] = vec4(0.3,0.3,0.6,ao);
	// fragColor[0] = vec4(ssaoAmbientColor.rgb,ao);
	// fragColor[0] = vec4(vec3(ao),1.0);
	// fragColor[0] = vec4(vec3(position.z / 1000.0),1.0);
	// fragColor[0] = vec4(normal,1.0);
	// fragColor[0] = vec4(normal,1.0);
	// fragColor[0] = vec4(rand.x,rand.y,0,1.0);
	fragColor[1] = vec4(0);
}



