#version 330
in vec4 frontColor;
out vec4 fragColor;

in vec4 worldPosition;
uniform float globalTime;

void main(void)
{
	vec4 color = frontColor;

	float stripeScrollSpeed = 500.0;
	float off = worldPosition.x + worldPosition.z + globalTime * stripeScrollSpeed;

	float stripeWidth = 100.0;
	uint stripe = uint(floor(off / stripeWidth));
	float posInStripe = off - stripe*stripeWidth;

	float amt = smoothstep(45.0, 55.0, posInStripe);
	color = mix(color.rgba, vec4(1.0,1.0,1.0,1.0), amt);

	fragColor.rgba = color;
}

