#version 330
uniform sampler2D terrainColorTexture;
uniform sampler2D terrainNormalTexture;
uniform sampler2D terrainTintTexture;
uniform sampler2D terrainDetailTexture;
uniform sampler2D terrainOverlayTexture;
uniform sampler2D terrainOverlayGlowTexture;
uniform sampler2D clutterOverlayTexture;
in vec2 fragTexcoord;
in vec2 microTexcoord;
// in vec2 overlayTexcoord;
// in float overlayMod;
in float fogFactor;
// in vec4 shadowCoord;
in vec3 cameraToFragment;
in vec3 local_light_pos;
in vec4 viewPosition;
uniform bool shadowOnly;
uniform mat4 worldToView;

uniform vec3 fogColor;
uniform bool rezEffect;
uniform float rezTime;
uniform float rezGridDims = 400.0;
uniform float rezDelayPerGrid = 0.05;
uniform float rezOriginX = 0.0;
uniform float rezOriginY = 0.0;
uniform float rezOriginZ = 0.0;
uniform float rezExpandTime = 0.5;
uniform float rezFadeTime = 2.0;
uniform float rezRandomExtraDelay = 2.0;

uniform vec4 overlayBox[4]; // .xyzw == minX,minZ,maxX,maxZ
uniform vec4 overlayMap[4]; // .xyzw == +x,+z,*x,*z, to convert from overlay box coords to texture coords.
uniform int overlayCascades;

struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];
// in vec4 frontColor;
out vec4 fragColor[3];

in vec4 worldPosition;

/////////////////////////////////////////////////////////////////////////////////
// The following are from https://www.shadertoy.com/view/4dS3Wd
float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }
float noise(float x) { float i = floor(x); float f = fract(x); float u = f * f * (3.0 - 2.0 * f); return mix(hash(i), hash(i + 1.0), u); }
float noise(vec2 x) { vec2 i = floor(x); vec2 f = fract(x); float a = hash(i); float b = hash(i + vec2(1.0, 0.0)); float c = hash(i + vec2(0.0, 1.0)); float d = hash(i + vec2(1.0, 1.0)); vec2 u = f * f * (3.0 - 2.0 * f); return mix(a, b, u.x) + (c - a) * u.y * (1.0 - u.x) + (d - b) * u.x * u.y; }
float noise(vec3 p)
{
	const vec3 s = vec3(7, 157, 113);
	vec3 ip = floor(p); p -= ip;
	vec4 h = vec4(0,s.yz,s.y+s.z) + dot(ip, s);
	p = p*p*(3.0 - 2.0 * p);
	h = mix(fract(sin(h)*43758.5453), fract(sin(h+s.x)*43758.5453), p.x);
	h.xy = mix(h.xz, h.yw, p.y);
	return mix(h.x, h.y, p.z); // range [0 .. 1]

	// const vec3 step = vec3(110, 241, 171);
	// vec3 i = floor(x);
	// vec3 f = fract(x);
	// float n = dot(i, step);
	// vec3 u = f * f * (3.0 - 2.0 * f);
	// return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x), mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y), mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x), mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z);
}

#define PI 3.1415926

#include "shade_h.glsl"
#include "shadow_h.glsl"

int calculateOverlayLevel()
{
	for ( int i = 0; i < overlayCascades; i++ )
	{
		float margin = 0.0;
		if ( overlayBox[i].x+margin < worldPosition.x &&
				overlayBox[i].y+margin < worldPosition.z &&
				overlayBox[i].z-margin > worldPosition.x &&
				overlayBox[i].w-margin > worldPosition.z )
		{
			return i;
		}
	}
	return -1;
}

vec2 calculateOverlayCoordinate(int level)
{
	{
		vec2 boxPos = vec2(
				(worldPosition.x - overlayBox[level].x) / (overlayBox[level].z - overlayBox[level].x),
				(worldPosition.z - overlayBox[level].y) / (overlayBox[level].w - overlayBox[level].y)
				);
		vec2 texCoord = (boxPos * overlayMap[level].zw) + overlayMap[level].xy;
		return texCoord;
	}
}

void main()
{
	vec4 diffuse = texture(terrainColorTexture, fragTexcoord.st);
	vec3 fragNormal = 2.0 * texture(terrainNormalTexture, fragTexcoord.st).rgb - vec3(1.0);
	vec4 tint = texture(terrainTintTexture, fragTexcoord.st);
	vec3 microNormal = 2.0 * texture(terrainDetailTexture, microTexcoord.st).rgb - vec3(1.0);
	vec4 overlayGlow = vec4(0,0,0,1);

	if ( worldPosition.y < 0.0 )
		discard;

	vec4 color = diffuse;
	vec4 overlay;
	vec4 clutterOverlay;
	int overlayLevel = calculateOverlayLevel();
	if ( overlayLevel >= 0 )
	{
		vec2 overlayTexcoord = calculateOverlayCoordinate(overlayLevel);

		overlay = texture(terrainOverlayTexture, vec2(overlayTexcoord.s, overlayTexcoord.t));
		overlayGlow = texture(terrainOverlayGlowTexture, overlayTexcoord.st);
		clutterOverlay = texture(clutterOverlayTexture, overlayTexcoord.st);

		color.rgb = mix(color.rgb, overlay.rgb, overlay.a);
	}
	color.rgb = mix(color.rgb, tint.rgb, tint.a);
	if (overlayLevel >= 0 )
	{
		color.rgb = mix(color.rgb, clutterOverlay.rgb, max(0.0,clutterOverlay.a - overlay.a));
	}

	vec3 normalFragNormal = normalize(fragNormal);
	float fragNormalDotL = dot(normalFragNormal,lightSource[0].position);
	float macroNdotL = dot(normalFragNormal,lightSource[0].position);

	/* fragNormal = mix(fragNormal, microNormal, 0.1); */
	fragNormal = fragNormal + (microNormal * 0.05);
	vec3 n = normalize(fragNormal);
	float rawNdotL = dot(n,lightSource[0].position);
	float illuminated = calculate_shadow_illumination( worldPosition, rawNdotL );
	float glow = 0.0;
	if ( shadowOnly )
		illuminated = 1.0;

	if ( rawNdotL < 0.0 )
		illuminated = 0.0;

	vec3 N = normalize( (worldToView * vec4(fragNormal,0.0)).xyz );
	vec3 L = normalize(local_light_pos);
	vec3 V = normalize(-cameraToFragment);
	vec3 H = normalize(L + V);

	float specular = 0.0;
	float rimSpecular = 0.30;
	float roughness = 0.8;
	float specRoughness = 0.85;
	float subsurface = 0.0;
	float clearcoat = 0.0;
	vec3 linearColor;

	color.rgb = shade(color.rgb, linearColor, N,L,V,H,
			illuminated, specular, rimSpecular, roughness, specRoughness, subsurface,
			clearcoat, fogColor.rgb, 1.0 - fogFactor, true);
	// color.rgb = mix(fogColor.rgb, color.rgb, fogFactor );

	N = normalize( (worldToView * vec4(normalFragNormal,0.0)).xyz );
	// fragColor[2].rgba = vec4( (0.4 + 0.1 * length(cameraToFragment)) * vec3(N), 1.0);
	// fragColor[2].rgba = vec4( (1.0) * vec3(N), 1.0);
	vec3 dx = dFdx( cameraToFragment );
	vec3 dy = -dFdy( cameraToFragment );
	vec3 triangleN = normalize(cross(dx,dy));

	// float d = (0.4 + length(cameraToFragment) * 0.05);
	// float dist = clamp( 100.0, length(cameraToFragment), 200.0 ); // clamps distance into [100..200]
	// float dist_fraction = (dist-100.0)/100.0;

	float minDist = 100.0;
	float maxDist = 1000.0;
	float dist = length(cameraToFragment);
	float dist_fraction = smoothstep( minDist, maxDist, dist );
	// float normal_scale = 3.0;
	float normal_scale = mix( 2.5, 5.0, dist_fraction ); // mix from first to second
	// float normal_scale = 3.0f;//mix( 0.5, 0.5, dist_fraction ); // mix from first to second

	// our normal gbuffer is at a 5x scale.  So we need to divide by 5.

	// vec3 mungedN =  0.5 * ((triangleN * (normal_scale/5.0)) + vec3(1.0));
	// vec3 mungedN =  0.5 * (triangleN + vec3(1.0));
	vec3 mungedN = 0.5 * ((normal_scale/10.0 * triangleN) + vec3(1.0));
	// vec3 mungedN = 0.5 * ((normal_scale/10.0 * N) + vec3(1.0));
	// vec3 mungedN =  vec3(0.0,0.0,1.0);//0.5 * ((triangleN * (normal_scale/5.0)) + vec3(1.0));
	fragColor[2].rgba = vec4( mungedN, 1.0);

	if ( rezEffect )
	{
		float time = rezTime;

		float gridDims = rezGridDims;
		float delayPerGrid = rezDelayPerGrid;
		float halfGridDims = gridDims * 0.5;
		vec3 relativePosition = worldPosition.xyz - vec3(rezOriginX, rezOriginY, rezOriginZ);

		uint xGridSquare = uint(floor(relativePosition.x / gridDims));
		uint yGridSquare = uint(floor(relativePosition.y / gridDims));
		uint zGridSquare = uint(floor(relativePosition.z / gridDims));
		float xGridPos = relativePosition.x - xGridSquare*gridDims;
		float yGridPos = relativePosition.y - yGridSquare*gridDims;
		float zGridPos = relativePosition.z - zGridSquare*gridDims;

		float distanceFromGridEdge = min( min( xGridPos, yGridPos ), zGridPos);
		distanceFromGridEdge = min( distanceFromGridEdge, gridDims - xGridPos );
		distanceFromGridEdge = min( distanceFromGridEdge, gridDims - yGridPos );
		distanceFromGridEdge = min( distanceFromGridEdge, gridDims - zGridPos );
		distanceFromGridEdge = distanceFromGridEdge / halfGridDims; // [0..1] for 'grid edge' to 'center'

		float extraDelay = noise( vec3(xGridSquare,yGridSquare, zGridSquare) );
		/* float extraDelay = float(munge) / 4294967295.0; */
		extraDelay *= extraDelay * extraDelay;
		extraDelay *= rezRandomExtraDelay;

		// effect moves across the ground from -x to +x and -y to +y.
		float delay = (delayPerGrid * (yGridSquare + xGridSquare)) + extraDelay;

		float delta = time - delay;

		if ( delta < 0 )
			discard;
		if ( delta < rezExpandTime )
		{
			float f = delta * (1.0 / rezExpandTime);
			f = 3.0 * f * f - 2.0 * f * f * f;
			if ( distanceFromGridEdge > f )
				discard;

			fragColor[0].rgba = vec4(color.rgb,f);
			fragColor[1].rgba = vec4(0.0, 1.0, 1.0, 0.5 * f);
			return;
		}
		else if ( delta < rezFadeTime )
		{
			float thisPhaseTime = delta - rezExpandTime;
			thisPhaseTime = thisPhaseTime / (rezFadeTime - rezExpandTime);
			float f = thisPhaseTime;
			f = 3.0 * f * f - 2.0 * f * f * f;
			float distanceFromCenter = 1.0 - distanceFromGridEdge;
			if ( distanceFromCenter > f )
			{
				fragColor[1].rgba = vec4(0.0, 1.0-f, 1.0-f, 0.5 * (1.0-f));
				/* fragColor[1].rgba = mix(vec4(0.0,1.0,1.0,0.5), vec4(color.rgb * glow, 1.0), f); */
			}
			else
			{
				fragColor[1].rgba = vec4(color.rgb * glow, 1.0);
			}
			fragColor[0].rgba = vec4(color.rgb,1.0);
			return;
		}
	}

	fragColor[0].rgba = vec4(color.rgb,1.0);
	// fragColor[0].rgb = mix( fragColor[0].rgb, N, 0.99 );
	fragColor[1].rgba = vec4(overlayGlow.rgb,1.0);//vec4(0.0, 0.0, 0.0, 1.0);

	// vec3 fdx = dFdx(cameraToFragment);
	// vec3 fdy = dFdy(cameraToFragment);
	// N = normalize(cross(fdx, fdy));
}


