#version 330
in mat4 localToWorldAttrib;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
in vec4 instanceColorAttrib;

uniform vec4 universal_color;

out vec3 cameraToFragment;
in vec4 vertex;

out vec4 frontColor;
out vec4 worldPosition;

void main(void)
{
	frontColor = instanceColorAttrib * universal_color;
	worldPosition = localToWorldAttrib * vertex;
	gl_Position = viewToProjection * worldToView * worldPosition;

	cameraToFragment = vec3(gl_Position);
}

