/*
 * Decompiled with CFR 0.152.
 */
package gui;

import Util.Util;
import amidst.mojangapi.minecraftinterface.MinecraftInterfaceCreationException;
import amidst.mojangapi.world.biome.Biome;
import amidst.mojangapi.world.biome.UnknownBiomeIndexException;
import amidst.parsing.FormatException;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import main.BiomeSearcher;

public class GUI {
    private JFrame frmSeedTool;
    private final JTabbedPane tabbedPane = new JTabbedPane(1);
    private static final int DELAY = 0;
    static Timer timer;
    public static boolean running;
    public static boolean paused;
    private static long startTime;
    private static long elapsedTime;
    static JButton btnClear;
    static JButton btnStart;
    static JButton btnPause;
    public static JPanel checkBoxes;
    public static String[] biomeSelected;
    ButtonListener listener = new ButtonListener();
    public static JLabel seedCount;
    public static JLabel totalSeedCount;
    public static JLabel timeElapsed;
    public static JTextArea console;
    static Thread t;
    static BiomeSearcher r;
    private static JTextField widthSearch;
    private static JTextField heightSearch;
    private static JTextField maxSeeds;
    private static int searchQuadrantWidth;
    private static int searchQuadrantHeight;
    private static int maximumMatchingWorldsCount;

    static {
        elapsedTime = 0L;
        searchQuadrantWidth = 2048;
        searchQuadrantHeight = 2048;
        maximumMatchingWorldsCount = 10;
    }

    public static void main(String ... args) throws IOException, FormatException, MinecraftInterfaceCreationException {
        new GUI().startSeedSearcher();
    }

    static BiomeSearcher createNewThread() throws IOException, FormatException, MinecraftInterfaceCreationException {
        String minecraftVersionId = "1.13";
        BiomeSearcher.SearchCenterKind searchCenterKind = BiomeSearcher.SearchCenterKind.ORIGIN;
        r = new BiomeSearcher(minecraftVersionId, searchCenterKind, Integer.parseInt(widthSearch.getText()), Integer.parseInt(heightSearch.getText()), Integer.parseInt(maxSeeds.getText()));
        return r;
    }

    void startSeedSearcher() throws IOException, FormatException, MinecraftInterfaceCreationException {
        this.initTimer();
        Util.console("Please select Biomes first!");
    }

    private void initTimer() {
        AbstractAction updateLabelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.updateDisplay();
            }
        };
        timer = new Timer(0, updateLabelAction);
    }

    private static void updateDisplay() {
        if (!paused) {
            elapsedTime = System.currentTimeMillis() - startTime;
            timeElapsed.setText("Time Elapsed: " + Util.getElapsedTimeHoursMinutesFromMilliseconds(elapsedTime));
        }
    }

    private static void toggleRunning() throws InterruptedException, IOException, FormatException, MinecraftInterfaceCreationException {
        if (running) {
            System.out.println("Shutting Down...");
            GUI.stop();
        } else {
            GUI.start();
        }
    }

    private static void start() throws IOException, FormatException, MinecraftInterfaceCreationException {
        t = new Thread(GUI.createNewThread());
        startTime = System.currentTimeMillis();
        running = true;
        t.start();
        timer.restart();
        btnStart.setText("Stop");
    }

    public static void stop() throws InterruptedException, IOException, FormatException, MinecraftInterfaceCreationException {
        btnStart.setText("Start");
        running = false;
        timer.stop();
        t.interrupt();
        t.join(1000L);
        t = new Thread(GUI.createNewThread());
    }

    private static void togglePause() {
        paused = !paused;
        String text = paused ? "Unfreeze" : "Freeze";
        long timeAtPause = 0L;
        if (paused) {
            timer.stop();
        } else {
            timer.start();
        }
        btnPause.setText(text);
        GUI.updateDisplay();
    }

    private static void reset() throws InterruptedException, IOException, FormatException, MinecraftInterfaceCreationException {
        if (paused) {
            GUI.togglePause();
        }
        if (running) {
            GUI.toggleRunning();
        }
        Util.consoleWipe();
        timeElapsed.setText("Time Elapsed: 00:00:00");
        startTime = System.currentTimeMillis();
        seedCount.setText("Rejected Seed Count: 0");
        totalSeedCount.setText("Total Rejected Seed Count: 0");
        GUI.updateDisplay();
    }

    public GUI() {
        this.initialize();
    }

    private void initialize() {
        this.frmSeedTool = new JFrame();
        this.frmSeedTool.setTitle("Seed Tool");
        this.frmSeedTool.setResizable(false);
        this.frmSeedTool.setBounds(100, 100, 644, 515);
        this.frmSeedTool.setDefaultCloseOperation(3);
        this.frmSeedTool.setVisible(true);
        this.frmSeedTool.getContentPane().setLayout(null);
        JPanel panel_3 = new JPanel();
        panel_3.setBounds(0, 0, 238, 26);
        this.frmSeedTool.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JLabel consoleLog = new JLabel("Console Output");
        consoleLog.setHorizontalAlignment(0);
        panel_3.add((Component)consoleLog, "Center");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(0, 25, 238, 461);
        this.frmSeedTool.getContentPane().add(scrollPane);
        console = new JTextArea();
        console.setLineWrap(true);
        scrollPane.setViewportView(console);
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.setBounds(237, 0, 401, 486);
        this.frmSeedTool.getContentPane().add(this.tabbedPane);
        JPanel panel = new JPanel();
        this.tabbedPane.addTab("Data", null, panel, null);
        panel.setLayout(null);
        seedCount = new JLabel("Rejected Seed Count: 0");
        seedCount.setBounds(10, 11, 212, 14);
        panel.add(seedCount);
        timeElapsed = new JLabel("Time Elapsed: 00:00:00");
        timeElapsed.setBounds(10, 331, 212, 14);
        panel.add(timeElapsed);
        totalSeedCount = new JLabel("Total Rejected Seed Count: 0");
        totalSeedCount.setBounds(10, 36, 212, 14);
        panel.add(totalSeedCount);
        btnStart = new JButton("Start");
        btnStart.addActionListener(this.listener);
        btnStart.setBounds(10, 356, 141, 23);
        panel.add(btnStart);
        btnPause = new JButton("Pause");
        btnPause.addActionListener(this.listener);
        btnPause.setBounds(10, 390, 141, 23);
        panel.add(btnPause);
        btnClear = new JButton("Clear");
        btnClear.addActionListener(this.listener);
        btnClear.setBounds(10, 424, 141, 23);
        panel.add(btnClear);
        JLabel lblSearchSize = new JLabel("Search Size: (Width, Height) D: 2048");
        lblSearchSize.setBounds(174, 360, 212, 14);
        panel.add(lblSearchSize);
        widthSearch = new JTextField();
        widthSearch.setText("" + searchQuadrantWidth);
        widthSearch.setBounds(170, 391, 86, 20);
        panel.add(widthSearch);
        widthSearch.setColumns(10);
        heightSearch = new JTextField();
        heightSearch.setText("" + searchQuadrantHeight);
        heightSearch.setBounds(300, 391, 86, 20);
        panel.add(heightSearch);
        heightSearch.setColumns(10);
        JLabel maxSeedsLabel = new JLabel("Max # Seeds to Find:");
        maxSeedsLabel.setBounds(161, 428, 121, 14);
        panel.add(maxSeedsLabel);
        maxSeeds = new JTextField();
        maxSeeds.setText("" + maximumMatchingWorldsCount);
        maxSeeds.setBounds(300, 427, 86, 20);
        panel.add(maxSeeds);
        maxSeeds.setColumns(10);
        JPanel panel_1 = new JPanel();
        this.tabbedPane.addTab("Selection", null, panel_1, null);
        panel_1.setLayout(null);
        JLabel lblNewLabel = new JLabel("Biome Selection");
        lblNewLabel.setBounds(0, 0, 396, 34);
        lblNewLabel.setHorizontalAlignment(0);
        panel_1.add(lblNewLabel);
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setHorizontalScrollBarPolicy(31);
        scrollPane_1.setBounds(0, 33, 396, 427);
        panel_1.add(scrollPane_1);
        checkBoxes = new JPanel();
        scrollPane_1.setViewportView(checkBoxes);
        checkBoxes.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        JCheckBox chckbxNewCheckBox = new JCheckBox("Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox, "2, 2");
        JCheckBox chckbxNewCheckBox_1 = new JCheckBox("Plains");
        checkBoxes.add((Component)chckbxNewCheckBox_1, "4, 2");
        JCheckBox chckbxNewCheckBox_3 = new JCheckBox("Desert");
        checkBoxes.add((Component)chckbxNewCheckBox_3, "2, 4");
        JCheckBox chckbxNewCheckBox_4 = new JCheckBox("Extreme Hills");
        checkBoxes.add((Component)chckbxNewCheckBox_4, "4, 4");
        JCheckBox chckbxNewCheckBox_5 = new JCheckBox("Forest");
        checkBoxes.add((Component)chckbxNewCheckBox_5, "2, 6");
        JCheckBox chckbxNewCheckBox_6 = new JCheckBox("Taiga");
        checkBoxes.add((Component)chckbxNewCheckBox_6, "4, 6");
        JCheckBox chckbxNewCheckBox_7 = new JCheckBox("Swampland");
        checkBoxes.add((Component)chckbxNewCheckBox_7, "2, 8");
        JCheckBox chckbxNewCheckBox_8 = new JCheckBox("River");
        checkBoxes.add((Component)chckbxNewCheckBox_8, "4, 8");
        JCheckBox chckbxNewCheckBox_9 = new JCheckBox("Hell");
        checkBoxes.add((Component)chckbxNewCheckBox_9, "2, 10");
        chckbxNewCheckBox_9.setEnabled(false);
        JCheckBox chckbxNewCheckBox_10 = new JCheckBox("The End");
        checkBoxes.add((Component)chckbxNewCheckBox_10, "4, 10");
        chckbxNewCheckBox_10.setEnabled(false);
        JCheckBox chckbxNewCheckBox_11 = new JCheckBox("Frozen Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_11, "2, 12");
        JCheckBox chckbxNewCheckBox_12 = new JCheckBox("Frozen River");
        checkBoxes.add((Component)chckbxNewCheckBox_12, "4, 12");
        JCheckBox chckbxNewCheckBox_13 = new JCheckBox("Ice Plains");
        checkBoxes.add((Component)chckbxNewCheckBox_13, "2, 14");
        JCheckBox chckbxNewCheckBox_14 = new JCheckBox("Ice Mountains");
        checkBoxes.add((Component)chckbxNewCheckBox_14, "4, 14");
        JCheckBox chckbxNewCheckBox_15 = new JCheckBox("Mushroom Island");
        checkBoxes.add((Component)chckbxNewCheckBox_15, "2, 16");
        JCheckBox chckbxNewCheckBox_16 = new JCheckBox("Mushroom Island Shore");
        checkBoxes.add((Component)chckbxNewCheckBox_16, "4, 16");
        JCheckBox chckbxNewCheckBox_17 = new JCheckBox("Beach");
        checkBoxes.add((Component)chckbxNewCheckBox_17, "2, 18");
        JCheckBox chckbxNewCheckBox_18 = new JCheckBox("Desert Hills");
        checkBoxes.add((Component)chckbxNewCheckBox_18, "4, 18");
        JCheckBox chckbxNewCheckBox_19 = new JCheckBox("Forest Hills");
        checkBoxes.add((Component)chckbxNewCheckBox_19, "2, 20");
        JCheckBox chckbxNewCheckBox_20 = new JCheckBox("Extreme Hills Edge");
        checkBoxes.add((Component)chckbxNewCheckBox_20, "4, 20");
        JCheckBox chckbxNewCheckBox_21 = new JCheckBox("Jungle");
        checkBoxes.add((Component)chckbxNewCheckBox_21, "2, 22");
        JCheckBox chckbxNewCheckBox_22 = new JCheckBox("Jungle Hills");
        checkBoxes.add((Component)chckbxNewCheckBox_22, "4, 22");
        JCheckBox chckbxNewCheckBox_23 = new JCheckBox("Jungle Edge");
        checkBoxes.add((Component)chckbxNewCheckBox_23, "2, 24");
        JCheckBox chckbxNewCheckBox_24 = new JCheckBox("Deep Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_24, "4, 24");
        JCheckBox chckbxNewCheckBox_25 = new JCheckBox("Stone Beach");
        checkBoxes.add((Component)chckbxNewCheckBox_25, "2, 26");
        JCheckBox chckbxNewCheckBox_26 = new JCheckBox("Cold Beach");
        checkBoxes.add((Component)chckbxNewCheckBox_26, "4, 26");
        JCheckBox chckbxNewCheckBox_27 = new JCheckBox("Birch Forest");
        checkBoxes.add((Component)chckbxNewCheckBox_27, "2, 28");
        JCheckBox chckbxNewCheckBox_28 = new JCheckBox("Birch Forest Hills");
        checkBoxes.add((Component)chckbxNewCheckBox_28, "4, 28");
        JCheckBox chckbxNewCheckBox_29 = new JCheckBox("Roofed Forest");
        checkBoxes.add((Component)chckbxNewCheckBox_29, "2, 30");
        JCheckBox chckbxNewCheckBox_30 = new JCheckBox("Cold Taiga");
        checkBoxes.add((Component)chckbxNewCheckBox_30, "4, 30");
        JCheckBox chckbxNewCheckBox_31 = new JCheckBox("Cold Taiga Hills");
        checkBoxes.add((Component)chckbxNewCheckBox_31, "2, 30");
        JCheckBox chckbxNewCheckBox_2 = new JCheckBox("Mega Taiga");
        checkBoxes.add((Component)chckbxNewCheckBox_2, "2, 32");
        JCheckBox chckbxNewCheckBox_32 = new JCheckBox("Mega Taiga Hills");
        checkBoxes.add((Component)chckbxNewCheckBox_32, "4, 32");
        JCheckBox chckbxNewCheckBox_33 = new JCheckBox("Extreme Hills+");
        checkBoxes.add((Component)chckbxNewCheckBox_33, "2, 34");
        JCheckBox chckbxNewCheckBox_34 = new JCheckBox("Savanna");
        checkBoxes.add((Component)chckbxNewCheckBox_34, "4, 34");
        JCheckBox chckbxNewCheckBox_35 = new JCheckBox("Savanna Plateau");
        checkBoxes.add((Component)chckbxNewCheckBox_35, "2, 36");
        JCheckBox chckbxNewCheckBox_36 = new JCheckBox("Mesa");
        checkBoxes.add((Component)chckbxNewCheckBox_36, "4, 36");
        JCheckBox chckbxNewCheckBox_37 = new JCheckBox("Mesa Plateau F");
        checkBoxes.add((Component)chckbxNewCheckBox_37, "2, 38");
        JCheckBox chckbxNewCheckBox_38 = new JCheckBox("Mesa Plateau");
        checkBoxes.add((Component)chckbxNewCheckBox_38, "4, 38");
        JCheckBox chckbxNewCheckBox_39 = new JCheckBox("The End - Floating islands");
        checkBoxes.add((Component)chckbxNewCheckBox_39, "2, 40");
        chckbxNewCheckBox_39.setEnabled(false);
        JCheckBox chckbxNewCheckBox_40 = new JCheckBox("The End - Medium island");
        checkBoxes.add((Component)chckbxNewCheckBox_40, "4, 40");
        chckbxNewCheckBox_40.setEnabled(false);
        JCheckBox chckbxNewCheckBox_41 = new JCheckBox("The End - High island");
        checkBoxes.add((Component)chckbxNewCheckBox_41, "2, 42");
        chckbxNewCheckBox_41.setEnabled(false);
        JCheckBox chckbxNewCheckBox_42 = new JCheckBox("The End - Barren island");
        checkBoxes.add((Component)chckbxNewCheckBox_42, "4, 42");
        chckbxNewCheckBox_42.setEnabled(false);
        JCheckBox chckbxNewCheckBox_43 = new JCheckBox("Warm Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_43, "2, 44");
        JCheckBox chckbxNewCheckBox_44 = new JCheckBox("Lukewarm Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_44, "4, 44");
        JCheckBox chckbxNewCheckBox_45 = new JCheckBox("Cold Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_45, "2, 46");
        JCheckBox chckbxNewCheckBox_46 = new JCheckBox("Warm Deep Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_46, "4, 46");
        chckbxNewCheckBox_46.setEnabled(false);
        JCheckBox chckbxNewCheckBox_47 = new JCheckBox("Lukewarm Deep Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_47, "2, 48");
        JCheckBox chckbxNewCheckBox_48 = new JCheckBox("Cold Deep Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_48, "4, 48");
        JCheckBox chckbxNewCheckBox_49 = new JCheckBox("Frozen Deep Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_49, "2, 50");
        JCheckBox chckbxNewCheckBox_50 = new JCheckBox("The Void");
        checkBoxes.add((Component)chckbxNewCheckBox_50, "4, 50");
        chckbxNewCheckBox_50.setEnabled(false);
        JCheckBox chckbxNewCheckBox_51 = new JCheckBox("Sunflower Plains");
        checkBoxes.add((Component)chckbxNewCheckBox_51, "2, 52");
        JCheckBox chckbxNewCheckBox_52 = new JCheckBox("Desert M");
        checkBoxes.add((Component)chckbxNewCheckBox_52, "4, 52");
        JCheckBox chckbxNewCheckBox_53 = new JCheckBox("Extreme Hills M");
        checkBoxes.add((Component)chckbxNewCheckBox_53, "2, 54");
        JCheckBox chckbxNewCheckBox_54 = new JCheckBox("Flower Forest");
        checkBoxes.add((Component)chckbxNewCheckBox_54, "4, 54");
        JCheckBox chckbxNewCheckBox_55 = new JCheckBox("Taiga M");
        checkBoxes.add((Component)chckbxNewCheckBox_55, "2, 56");
        JCheckBox chckbxNewCheckBox_56 = new JCheckBox("Swampland M");
        checkBoxes.add((Component)chckbxNewCheckBox_56, "4, 56");
        JCheckBox chckbxNewCheckBox_57 = new JCheckBox("Ice Plains Spikes");
        checkBoxes.add((Component)chckbxNewCheckBox_57, "2, 58");
        JCheckBox chckbxNewCheckBox_58 = new JCheckBox("Jungle M");
        checkBoxes.add((Component)chckbxNewCheckBox_58, "4, 58");
        JCheckBox chckbxNewCheckBox_59 = new JCheckBox("Jungle Edge M");
        checkBoxes.add((Component)chckbxNewCheckBox_59, "2, 60");
        JCheckBox chckbxNewCheckBox_60 = new JCheckBox("Birch Forest M");
        checkBoxes.add((Component)chckbxNewCheckBox_60, "4, 60");
        JCheckBox chckbxNewCheckBox_61 = new JCheckBox("Birch Forest Hills M");
        checkBoxes.add((Component)chckbxNewCheckBox_61, "2, 62");
        JCheckBox chckbxNewCheckBox_62 = new JCheckBox("Roofed Forest M");
        checkBoxes.add((Component)chckbxNewCheckBox_62, "4, 62");
        JCheckBox chckbxNewCheckBox_63 = new JCheckBox("Cold Taiga M");
        checkBoxes.add((Component)chckbxNewCheckBox_63, "2, 64");
        JCheckBox chckbxNewCheckBox_64 = new JCheckBox("Mega Spruce Taiga");
        checkBoxes.add((Component)chckbxNewCheckBox_64, "4, 64");
        JCheckBox chckbxNewCheckBox_65 = new JCheckBox("Mega Spruce Taiga (Hills)");
        checkBoxes.add((Component)chckbxNewCheckBox_65, "2, 66");
        JCheckBox chckbxNewCheckBox_66 = new JCheckBox("Extreme Hills+ M");
        checkBoxes.add((Component)chckbxNewCheckBox_66, "4, 66");
        JCheckBox chckbxNewCheckBox_67 = new JCheckBox("Savanna M");
        checkBoxes.add((Component)chckbxNewCheckBox_67, "2, 68");
        JCheckBox chckbxNewCheckBox_68 = new JCheckBox("Savanna Plateau M");
        checkBoxes.add((Component)chckbxNewCheckBox_68, "4, 68");
        JCheckBox chckbxNewCheckBox_69 = new JCheckBox("Mesa (Bryce)");
        checkBoxes.add((Component)chckbxNewCheckBox_69, "2, 70");
        JCheckBox chckbxNewCheckBox_70 = new JCheckBox("Mesa Plateau F M");
        checkBoxes.add((Component)chckbxNewCheckBox_70, "4, 70");
        JCheckBox chckbxNewCheckBox_71 = new JCheckBox("Mesa Plateau M");
        checkBoxes.add((Component)chckbxNewCheckBox_71, "2, 72");
    }

    public static Biome[] manageCheckedCheckboxes() throws UnknownBiomeIndexException, InterruptedException, IOException, FormatException, MinecraftInterfaceCreationException {
        Component[] comps = checkBoxes.getComponents();
        ArrayList<String> checkedTexts = new ArrayList<String>();
        Component[] componentArray = comps;
        int n = comps.length;
        int n2 = 0;
        while (n2 < n) {
            JCheckBox box;
            Component comp = componentArray[n2];
            if (comp instanceof JCheckBox && (box = (JCheckBox)comp).isSelected()) {
                String text = box.getText();
                checkedTexts.add(text);
            }
            ++n2;
        }
        Biome[] biomes = new Biome[checkedTexts.size()];
        int i = 0;
        while (i < checkedTexts.size()) {
            biomes[i] = Biome.getByName((String)checkedTexts.get(i));
            ++i;
        }
        if (biomes.length == 0) {
            Util.console("Please select Biomes!\nPlease click start a few times to start again (Working on a fix)\nRecommend you clear also!");
            GUI.stop();
        }
        return biomes;
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source != "Biomes") {
            // empty if block
        }
        e.getStateChange();
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == btnStart) {
                try {
                    GUI.toggleRunning();
                }
                catch (MinecraftInterfaceCreationException | FormatException | IOException | InterruptedException e1) {
                    e1.printStackTrace();
                }
            } else if (e.getSource() == btnPause) {
                GUI.togglePause();
            } else if (e.getSource() == btnClear) {
                try {
                    GUI.reset();
                }
                catch (MinecraftInterfaceCreationException | FormatException | IOException | InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

