/*
 * Decompiled with CFR 0.152.
 */
package main;

import Util.Util;
import amidst.logging.AmidstLogger;
import amidst.mojangapi.file.LauncherProfile;
import amidst.mojangapi.file.MinecraftInstallation;
import amidst.mojangapi.minecraftinterface.MinecraftInterface;
import amidst.mojangapi.minecraftinterface.MinecraftInterfaceCreationException;
import amidst.mojangapi.minecraftinterface.MinecraftInterfaceException;
import amidst.mojangapi.minecraftinterface.MinecraftInterfaces;
import amidst.mojangapi.world.World;
import amidst.mojangapi.world.WorldBuilder;
import amidst.mojangapi.world.WorldOptions;
import amidst.mojangapi.world.WorldSeed;
import amidst.mojangapi.world.WorldType;
import amidst.mojangapi.world.biome.Biome;
import amidst.mojangapi.world.biome.UnknownBiomeIndexException;
import amidst.mojangapi.world.coordinates.CoordinatesInWorld;
import amidst.mojangapi.world.coordinates.Resolution;
import amidst.mojangapi.world.oracle.HeuristicWorldSpawnOracle;
import amidst.parsing.FormatException;
import gui.GUI;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Consumer;

public class BiomeSearcher
implements Runnable {
    private WorldBuilder mWorldBuilder;
    private MinecraftInterface mMinecraftInterface;
    public static SearchCenterKind mSearchCenterKind;
    private int mSearchQuadrantWidth;
    private int mSearchQuadrantHeight;
    private int mMaximumMatchingWorldsCount;
    static final CoordinatesInWorld CIW_ORIGIN;
    static final CoordinatesInWorld CIW_MAP_ORIGIN;
    Biome[] biomes = new Biome[0];
    static int totalRejectedSeedCount;

    static {
        CIW_ORIGIN = CoordinatesInWorld.from(0L, 0L);
        CIW_MAP_ORIGIN = CoordinatesInWorld.from(-64L, -64L);
        totalRejectedSeedCount = 0;
        AmidstLogger.removeListener("console");
        AmidstLogger.removeListener("master");
    }

    public BiomeSearcher(String minecraftVersion, SearchCenterKind searchCenterKind, int searchQuadrantWidth, int searchQuadrantHeight, int maximumMatchingWorldsCount) throws IOException, FormatException, MinecraftInterfaceCreationException {
        this.mWorldBuilder = WorldBuilder.createSilentPlayerless();
        MinecraftInstallation minecraftInstallation = MinecraftInstallation.newLocalMinecraftInstallation();
        LauncherProfile launcherProfile = minecraftInstallation.newLauncherProfile(minecraftVersion);
        this.mMinecraftInterface = MinecraftInterfaces.fromLocalProfile(launcherProfile);
        mSearchCenterKind = searchCenterKind;
        this.mSearchQuadrantWidth = searchQuadrantWidth;
        this.mSearchQuadrantHeight = searchQuadrantHeight;
        this.mMaximumMatchingWorldsCount = maximumMatchingWorldsCount;
    }

    World createWorld() throws MinecraftInterfaceException {
        Consumer<World> onDispose = world -> {};
        WorldOptions worldOptions = new WorldOptions(WorldSeed.random(), WorldType.DEFAULT);
        return this.mWorldBuilder.from(this.mMinecraftInterface, onDispose, worldOptions);
    }

    static CoordinatesInWorld getSpawn(World world) {
        HeuristicWorldSpawnOracle worldSpawnOracle = new HeuristicWorldSpawnOracle(world.getWorldSeed().getLong(), world.getBiomeDataOracle(), world.getVersionFeatures().getValidBiomesForStructure_Spawn());
        return worldSpawnOracle.get();
    }

    static long getSpawnChunksCenterCoordinate(long spawnCoordinate) {
        int spawnCoordinateRelativeToChunk = (int)(spawnCoordinate & 0xFL);
        switch (spawnCoordinateRelativeToChunk) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return spawnCoordinate & 0xFFFFFFFFFFFFFFF3L;
            }
            case 8: {
                return spawnCoordinate;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return (spawnCoordinate & 0xFFFFFFFFFFFFFFF3L) + 16L;
            }
        }
        throw new AssertionError(spawnCoordinateRelativeToChunk);
    }

    static CoordinatesInWorld getSpawnChunksCenter(World world) {
        CoordinatesInWorld spawn = BiomeSearcher.getSpawn(world);
        if (spawn == null) {
            return null;
        }
        long spawnX = spawn.getX();
        long spawnChunksCenterX = BiomeSearcher.getSpawnChunksCenterCoordinate(spawnX);
        long spawnY = spawn.getY();
        long spawnChunksCenterY = BiomeSearcher.getSpawnChunksCenterCoordinate(spawnY);
        return CoordinatesInWorld.from(spawnChunksCenterX, spawnChunksCenterY);
    }

    CoordinatesInWorld getSearchCenter(World world) {
        switch (mSearchCenterKind) {
            case ORIGIN: {
                return CIW_ORIGIN;
            }
            case MAP_ORIGIN: {
                return CIW_MAP_ORIGIN;
            }
            case SPAWN: {
                return BiomeSearcher.getSpawn(world);
            }
            case SPAWN_CHUNKS: {
                return BiomeSearcher.getSpawnChunksCenter(world);
            }
        }
        throw new AssertionError((Object)mSearchCenterKind);
    }

    int[] getBiomeCodes(long nwCornerX, long nwCornerY, int width, int height) throws MinecraftInterfaceException {
        return this.mMinecraftInterface.getBiomeData((int)Resolution.QUARTER.convertFromWorldToThis(nwCornerX), (int)Resolution.QUARTER.convertFromWorldToThis(nwCornerY), width / 4, height / 4, true);
    }

    boolean accept(World world) throws MinecraftInterfaceException, UnknownBiomeIndexException, InterruptedException, IOException, FormatException, MinecraftInterfaceCreationException {
        CoordinatesInWorld searchCenter = this.getSearchCenter(world);
        if (searchCenter == null) {
            return false;
        }
        long searchCenterX = searchCenter.getX();
        long searchCenterY = searchCenter.getY();
        int[] biomeCodes = this.getBiomeCodes(searchCenterX - (long)this.mSearchQuadrantWidth, searchCenterY - (long)this.mSearchQuadrantHeight, 2 * this.mSearchQuadrantWidth, 2 * this.mSearchQuadrantHeight);
        int biomeCodesCount = biomeCodes.length;
        if (this.biomes.length == 0) {
            Util.console("Creating Biomes from list");
            this.biomes = GUI.manageCheckedCheckboxes();
        }
        HashSet<Biome> undiscoveredBiomes = new HashSet<Biome>(Arrays.asList(this.biomes));
        int biomeCodeIndex = 0;
        while (biomeCodeIndex < biomeCodesCount) {
            if (undiscoveredBiomes.remove(Biome.getByIndex(biomeCodes[biomeCodeIndex])) && undiscoveredBiomes.isEmpty()) {
                return true;
            }
            ++biomeCodeIndex;
        }
        return false;
    }

    static void updateRejectedWorldsProgress(int rejectedWorldsCount) {
        GUI.seedCount.setText("Rejected Seed Count: " + rejectedWorldsCount);
        GUI.totalSeedCount.setText("Total Rejected Seed Count: " + totalRejectedSeedCount);
        if (rejectedWorldsCount % 16 == 0) {
            Util.consoleNoLine(".");
            if (rejectedWorldsCount % 1024 == 0) {
                Util.console("");
            }
        }
    }

    static void updateAcceptedWorldsProgress(int rejectedWorldsCount, int acceptedWorldsCount, World acceptedWorld) {
        if (rejectedWorldsCount / 16 > 0) {
            Util.console("");
        }
        Util.console(String.valueOf(acceptedWorldsCount) + ": " + acceptedWorld.getWorldSeed().getLong() + " (rejected " + rejectedWorldsCount + ")");
    }

    void search() throws InterruptedException, IOException, FormatException, MinecraftInterfaceCreationException {
        int rejectedWorldsCount = 0;
        int acceptedWorldsCount = 0;
        while (acceptedWorldsCount < this.mMaximumMatchingWorldsCount && GUI.running) {
            if (!GUI.paused) {
                boolean isWorldAccepted;
                World world;
                try {
                    world = this.createWorld();
                }
                catch (MinecraftInterfaceException e) {
                    ++totalRejectedSeedCount;
                    BiomeSearcher.updateRejectedWorldsProgress(++rejectedWorldsCount);
                    continue;
                }
                try {
                    isWorldAccepted = this.accept(world);
                }
                catch (MinecraftInterfaceException | UnknownBiomeIndexException e) {
                    ++totalRejectedSeedCount;
                    BiomeSearcher.updateRejectedWorldsProgress(++rejectedWorldsCount);
                    continue;
                }
                if (!isWorldAccepted) {
                    ++totalRejectedSeedCount;
                    BiomeSearcher.updateRejectedWorldsProgress(++rejectedWorldsCount);
                    continue;
                }
                BiomeSearcher.updateAcceptedWorldsProgress(rejectedWorldsCount, ++acceptedWorldsCount, world);
                rejectedWorldsCount = 0;
            }
            System.out.print("");
        }
        GUI.stop();
    }

    @Override
    public void run() {
        try {
            this.search();
        }
        catch (MinecraftInterfaceCreationException | FormatException | IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static enum SearchCenterKind {
        ORIGIN,
        MAP_ORIGIN,
        SPAWN,
        SPAWN_CHUNKS;

    }
}

