/*
 * Decompiled with CFR 0.152.
 */
package gui;

import Util.Util;
import amidst.mojangapi.minecraftinterface.MinecraftInterfaceCreationException;
import amidst.mojangapi.world.biome.Biome;
import amidst.mojangapi.world.biome.UnknownBiomeIndexException;
import amidst.parsing.FormatException;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import main.BiomeSearcher;

public class GUI {
    private JFrame frmSeedTool;
    private final JTabbedPane tabbedPane = new JTabbedPane(1);
    private static final int DELAY = 0;
    static Timer timer;
    public static boolean running;
    public static boolean paused;
    private static long startTime;
    private static long elapsedTime;
    static JButton btnClear;
    static JButton btnStart;
    static JButton btnPause;
    public static JCheckBox excludeBiome;
    public static JPanel checkBoxes;
    public static JPanel checkBoxes1;
    public static String[] biomeSelected;
    ButtonListener listener = new ButtonListener();
    public static JLabel seedCount;
    public static JLabel totalSeedCount;
    public static JLabel timeElapsed;
    public static JTextArea console;
    static Thread t;
    static BiomeSearcher r;
    private static JTextField widthSearch;
    private static JTextField heightSearch;
    private static JTextField maxSeeds;
    private static JTextField versionId;
    private static int searchQuadrantWidth;
    private static int searchQuadrantHeight;
    private static int maximumMatchingWorldsCount;
    private static String minecraftVersionId;

    static {
        elapsedTime = 0L;
        searchQuadrantWidth = 2048;
        searchQuadrantHeight = 2048;
        maximumMatchingWorldsCount = 10;
        minecraftVersionId = "1.13.2";
    }

    public static void main(String ... args) throws IOException, FormatException, MinecraftInterfaceCreationException {
        new GUI().startSeedSearcher();
    }

    static BiomeSearcher createNewThread() throws IOException, FormatException, MinecraftInterfaceCreationException {
        BiomeSearcher.SearchCenterKind searchCenterKind = BiomeSearcher.SearchCenterKind.ORIGIN;
        r = new BiomeSearcher(versionId.getText(), searchCenterKind, Integer.parseInt(widthSearch.getText()), Integer.parseInt(heightSearch.getText()), Integer.parseInt(maxSeeds.getText()));
        return r;
    }

    void startSeedSearcher() throws IOException, FormatException, MinecraftInterfaceCreationException {
        this.initTimer();
        Util.console("Please select Biomes first!");
    }

    private void initTimer() {
        AbstractAction updateLabelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.updateDisplay();
            }
        };
        timer = new Timer(0, updateLabelAction);
    }

    private static void updateDisplay() {
        if (!paused) {
            elapsedTime = System.currentTimeMillis() - startTime;
            timeElapsed.setText("Time Elapsed: " + Util.getElapsedTimeHoursMinutesFromMilliseconds(elapsedTime));
        }
    }

    private static void toggleRunning() throws InterruptedException, IOException, FormatException, MinecraftInterfaceCreationException {
        if (running) {
            System.out.println("Shutting Down...");
            GUI.stop();
        } else {
            GUI.start();
        }
    }

    private static void start() throws IOException, FormatException, MinecraftInterfaceCreationException {
        t = new Thread(GUI.createNewThread());
        startTime = System.currentTimeMillis();
        running = true;
        t.start();
        timer.restart();
        btnStart.setText("Stop");
        BiomeSearcher.totalRejectedSeedCount = 0;
    }

    public static void stop() throws InterruptedException, IOException, FormatException, MinecraftInterfaceCreationException {
        btnStart.setText("Start");
        running = false;
        timer.stop();
        t.interrupt();
        t.join(1000L);
        t = new Thread(GUI.createNewThread());
    }

    private static void togglePause() {
        paused = !paused;
        String text = paused ? "Unfreeze" : "Freeze";
        long timeAtPause = 0L;
        if (paused) {
            timer.stop();
            timeAtPause = System.currentTimeMillis();
        } else {
            timer.start();
        }
        btnPause.setText(text);
        GUI.updateDisplay();
    }

    private static void reset() throws InterruptedException, IOException, FormatException, MinecraftInterfaceCreationException {
        if (paused) {
            GUI.togglePause();
        }
        if (running) {
            GUI.toggleRunning();
        }
        Util.consoleWipe();
        timeElapsed.setText("Time Elapsed: 00:00:00");
        startTime = System.currentTimeMillis();
        seedCount.setText("Rejected Seed Count: 0");
        totalSeedCount.setText("Total Rejected Seed Count: 0");
        BiomeSearcher.totalRejectedSeedCount = 0;
        GUI.updateDisplay();
    }

    public GUI() {
        this.initialize();
    }

    private void initialize() {
        this.frmSeedTool = new JFrame();
        this.frmSeedTool.setTitle("Seed Tool");
        this.frmSeedTool.setResizable(false);
        this.frmSeedTool.setBounds(100, 100, 644, 515);
        this.frmSeedTool.setDefaultCloseOperation(3);
        this.frmSeedTool.setVisible(true);
        this.frmSeedTool.getContentPane().setLayout(null);
        JPanel panel_3 = new JPanel();
        panel_3.setBounds(0, 0, 238, 26);
        this.frmSeedTool.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JLabel consoleLog = new JLabel("Console Output");
        consoleLog.setHorizontalAlignment(0);
        panel_3.add((Component)consoleLog, "Center");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(0, 25, 238, 461);
        this.frmSeedTool.getContentPane().add(scrollPane);
        console = new JTextArea();
        console.setLineWrap(true);
        scrollPane.setViewportView(console);
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.setBounds(237, 0, 401, 486);
        this.frmSeedTool.getContentPane().add(this.tabbedPane);
        JPanel panel = new JPanel();
        this.tabbedPane.addTab("Data", null, panel, null);
        panel.setLayout(null);
        seedCount = new JLabel("Rejected Seed Count: 0");
        seedCount.setBounds(10, 11, 212, 14);
        panel.add(seedCount);
        timeElapsed = new JLabel("Time Elapsed: 00:00:00");
        timeElapsed.setBounds(10, 331, 212, 14);
        panel.add(timeElapsed);
        totalSeedCount = new JLabel("Total Rejected Seed Count: 0");
        totalSeedCount.setBounds(10, 36, 212, 14);
        panel.add(totalSeedCount);
        btnStart = new JButton("Start");
        btnStart.addActionListener(this.listener);
        btnStart.setBounds(10, 356, 141, 23);
        panel.add(btnStart);
        btnPause = new JButton("Pause");
        btnPause.addActionListener(this.listener);
        btnPause.setBounds(10, 390, 141, 23);
        panel.add(btnPause);
        btnClear = new JButton("Clear");
        btnClear.addActionListener(this.listener);
        btnClear.setBounds(10, 424, 141, 23);
        panel.add(btnClear);
        JLabel versionIdLabel = new JLabel("Minecraft Version:");
        versionIdLabel.setBounds(174, 331, 141, 14);
        panel.add(versionIdLabel);
        versionId = new JTextField();
        versionId.setText(minecraftVersionId);
        versionId.setBounds(300, 331, 86, 20);
        panel.add(versionId);
        versionId.setColumns(10);
        JLabel lblSearchSize = new JLabel("Search Size: (Width, Height) D: 2048");
        lblSearchSize.setBounds(174, 360, 212, 14);
        panel.add(lblSearchSize);
        widthSearch = new JTextField();
        widthSearch.setText("" + searchQuadrantWidth);
        widthSearch.setBounds(170, 391, 86, 20);
        panel.add(widthSearch);
        widthSearch.setColumns(10);
        heightSearch = new JTextField();
        heightSearch.setText("" + searchQuadrantHeight);
        heightSearch.setBounds(300, 391, 86, 20);
        panel.add(heightSearch);
        heightSearch.setColumns(10);
        JLabel maxSeedsLabel = new JLabel("Max # Seeds to Find:");
        maxSeedsLabel.setBounds(174, 428, 151, 14);
        panel.add(maxSeedsLabel);
        maxSeeds = new JTextField();
        maxSeeds.setText("" + maximumMatchingWorldsCount);
        maxSeeds.setBounds(300, 427, 86, 20);
        panel.add(maxSeeds);
        maxSeeds.setColumns(10);
        JLabel lblExcludeBiomes = new JLabel("Exclude biomes?");
        lblExcludeBiomes.setBounds(174, 306, 127, 14);
        panel.add(lblExcludeBiomes);
        excludeBiome = new JCheckBox("");
        excludeBiome.setBounds(331, 301, 21, 23);
        excludeBiome.addActionListener(this.listener);
        panel.add(excludeBiome);
        JPanel panel_1 = new JPanel();
        this.tabbedPane.addTab("Selection", null, panel_1, null);
        panel_1.setLayout(null);
        JLabel lblNewLabel = new JLabel("Biome Selection");
        lblNewLabel.setBounds(0, 0, 396, 34);
        lblNewLabel.setHorizontalAlignment(0);
        panel_1.add(lblNewLabel);
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setHorizontalScrollBarPolicy(31);
        scrollPane_1.setBounds(0, 33, 396, 427);
        panel_1.add(scrollPane_1);
        checkBoxes = new JPanel();
        scrollPane_1.setViewportView(checkBoxes);
        checkBoxes.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        JCheckBox chckbxNewCheckBox = new JCheckBox("Ocean (Always true)");
        checkBoxes.add((Component)chckbxNewCheckBox, "2, 2");
        chckbxNewCheckBox.setEnabled(false);
        JCheckBox chckbxNewCheckBox_1 = new JCheckBox("Plains");
        checkBoxes.add((Component)chckbxNewCheckBox_1, "4, 2");
        JCheckBox chckbxNewCheckBox_3 = new JCheckBox("Desert");
        checkBoxes.add((Component)chckbxNewCheckBox_3, "2, 4");
        JCheckBox chckbxNewCheckBox_4 = new JCheckBox("Extreme Hills");
        checkBoxes.add((Component)chckbxNewCheckBox_4, "4, 4");
        JCheckBox chckbxNewCheckBox_5 = new JCheckBox("Forest");
        checkBoxes.add((Component)chckbxNewCheckBox_5, "2, 6");
        JCheckBox chckbxNewCheckBox_6 = new JCheckBox("Taiga");
        checkBoxes.add((Component)chckbxNewCheckBox_6, "4, 6");
        JCheckBox chckbxNewCheckBox_7 = new JCheckBox("Swampland");
        checkBoxes.add((Component)chckbxNewCheckBox_7, "2, 8");
        JCheckBox chckbxNewCheckBox_8 = new JCheckBox("River");
        checkBoxes.add((Component)chckbxNewCheckBox_8, "4, 8");
        JCheckBox chckbxNewCheckBox_9 = new JCheckBox("Hell");
        checkBoxes.add((Component)chckbxNewCheckBox_9, "2, 10");
        chckbxNewCheckBox_9.setEnabled(false);
        JCheckBox chckbxNewCheckBox_10 = new JCheckBox("The End");
        checkBoxes.add((Component)chckbxNewCheckBox_10, "4, 10");
        chckbxNewCheckBox_10.setEnabled(false);
        JCheckBox chckbxNewCheckBox_11 = new JCheckBox("Frozen Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_11, "2, 12");
        JCheckBox chckbxNewCheckBox_12 = new JCheckBox("Frozen River");
        checkBoxes.add((Component)chckbxNewCheckBox_12, "4, 12");
        JCheckBox chckbxNewCheckBox_13 = new JCheckBox("Ice Plains");
        checkBoxes.add((Component)chckbxNewCheckBox_13, "2, 14");
        JCheckBox chckbxNewCheckBox_14 = new JCheckBox("Ice Mountains");
        checkBoxes.add((Component)chckbxNewCheckBox_14, "4, 14");
        JCheckBox chckbxNewCheckBox_15 = new JCheckBox("Mushroom Island");
        checkBoxes.add((Component)chckbxNewCheckBox_15, "2, 16");
        JCheckBox chckbxNewCheckBox_16 = new JCheckBox("Mushroom Island Shore");
        checkBoxes.add((Component)chckbxNewCheckBox_16, "4, 16");
        JCheckBox chckbxNewCheckBox_17 = new JCheckBox("Beach");
        checkBoxes.add((Component)chckbxNewCheckBox_17, "2, 18");
        JCheckBox chckbxNewCheckBox_18 = new JCheckBox("Desert Hills");
        checkBoxes.add((Component)chckbxNewCheckBox_18, "4, 18");
        JCheckBox chckbxNewCheckBox_19 = new JCheckBox("Forest Hills");
        checkBoxes.add((Component)chckbxNewCheckBox_19, "2, 20");
        JCheckBox chckbxNewCheckBox_20 = new JCheckBox("Extreme Hills Edge");
        checkBoxes.add((Component)chckbxNewCheckBox_20, "4, 20");
        JCheckBox chckbxNewCheckBox_21 = new JCheckBox("Jungle");
        checkBoxes.add((Component)chckbxNewCheckBox_21, "2, 22");
        JCheckBox chckbxNewCheckBox_22 = new JCheckBox("Jungle Hills");
        checkBoxes.add((Component)chckbxNewCheckBox_22, "4, 22");
        JCheckBox chckbxNewCheckBox_23 = new JCheckBox("Jungle Edge");
        checkBoxes.add((Component)chckbxNewCheckBox_23, "2, 24");
        JCheckBox chckbxNewCheckBox_24 = new JCheckBox("Deep Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_24, "4, 24");
        JCheckBox chckbxNewCheckBox_25 = new JCheckBox("Stone Beach");
        checkBoxes.add((Component)chckbxNewCheckBox_25, "2, 26");
        JCheckBox chckbxNewCheckBox_26 = new JCheckBox("Cold Beach");
        checkBoxes.add((Component)chckbxNewCheckBox_26, "4, 26");
        JCheckBox chckbxNewCheckBox_27 = new JCheckBox("Birch Forest");
        checkBoxes.add((Component)chckbxNewCheckBox_27, "2, 28");
        JCheckBox chckbxNewCheckBox_28 = new JCheckBox("Birch Forest Hills");
        checkBoxes.add((Component)chckbxNewCheckBox_28, "4, 28");
        JCheckBox chckbxNewCheckBox_29 = new JCheckBox("Roofed Forest");
        checkBoxes.add((Component)chckbxNewCheckBox_29, "2, 30");
        JCheckBox chckbxNewCheckBox_30 = new JCheckBox("Cold Taiga");
        checkBoxes.add((Component)chckbxNewCheckBox_30, "4, 30");
        JCheckBox chckbxNewCheckBox_31 = new JCheckBox("Cold Taiga Hills");
        checkBoxes.add((Component)chckbxNewCheckBox_31, "2, 30");
        JCheckBox chckbxNewCheckBox_2 = new JCheckBox("Mega Taiga");
        checkBoxes.add((Component)chckbxNewCheckBox_2, "2, 32");
        JCheckBox chckbxNewCheckBox_32 = new JCheckBox("Mega Taiga Hills");
        checkBoxes.add((Component)chckbxNewCheckBox_32, "4, 32");
        JCheckBox chckbxNewCheckBox_33 = new JCheckBox("Extreme Hills+");
        checkBoxes.add((Component)chckbxNewCheckBox_33, "2, 34");
        JCheckBox chckbxNewCheckBox_34 = new JCheckBox("Savanna");
        checkBoxes.add((Component)chckbxNewCheckBox_34, "4, 34");
        JCheckBox chckbxNewCheckBox_35 = new JCheckBox("Savanna Plateau");
        checkBoxes.add((Component)chckbxNewCheckBox_35, "2, 36");
        JCheckBox chckbxNewCheckBox_36 = new JCheckBox("Mesa");
        checkBoxes.add((Component)chckbxNewCheckBox_36, "4, 36");
        JCheckBox chckbxNewCheckBox_37 = new JCheckBox("Mesa Plateau F");
        checkBoxes.add((Component)chckbxNewCheckBox_37, "2, 38");
        JCheckBox chckbxNewCheckBox_38 = new JCheckBox("Mesa Plateau");
        checkBoxes.add((Component)chckbxNewCheckBox_38, "4, 38");
        JCheckBox chckbxNewCheckBox_39 = new JCheckBox("The End - Floating islands");
        checkBoxes.add((Component)chckbxNewCheckBox_39, "2, 40");
        chckbxNewCheckBox_39.setEnabled(false);
        JCheckBox chckbxNewCheckBox_40 = new JCheckBox("The End - Medium island");
        checkBoxes.add((Component)chckbxNewCheckBox_40, "4, 40");
        chckbxNewCheckBox_40.setEnabled(false);
        JCheckBox chckbxNewCheckBox_41 = new JCheckBox("The End - High island");
        checkBoxes.add((Component)chckbxNewCheckBox_41, "2, 42");
        chckbxNewCheckBox_41.setEnabled(false);
        JCheckBox chckbxNewCheckBox_42 = new JCheckBox("The End - Barren island");
        checkBoxes.add((Component)chckbxNewCheckBox_42, "4, 42");
        chckbxNewCheckBox_42.setEnabled(false);
        JCheckBox chckbxNewCheckBox_43 = new JCheckBox("Warm Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_43, "2, 44");
        JCheckBox chckbxNewCheckBox_44 = new JCheckBox("Lukewarm Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_44, "4, 44");
        JCheckBox chckbxNewCheckBox_45 = new JCheckBox("Cold Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_45, "2, 46");
        JCheckBox chckbxNewCheckBox_46 = new JCheckBox("Warm Deep Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_46, "4, 46");
        chckbxNewCheckBox_46.setEnabled(false);
        JCheckBox chckbxNewCheckBox_47 = new JCheckBox("Lukewarm Deep Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_47, "2, 48");
        JCheckBox chckbxNewCheckBox_48 = new JCheckBox("Cold Deep Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_48, "4, 48");
        JCheckBox chckbxNewCheckBox_49 = new JCheckBox("Frozen Deep Ocean");
        checkBoxes.add((Component)chckbxNewCheckBox_49, "2, 50");
        JCheckBox chckbxNewCheckBox_50 = new JCheckBox("The Void");
        checkBoxes.add((Component)chckbxNewCheckBox_50, "4, 50");
        chckbxNewCheckBox_50.setEnabled(false);
        JCheckBox chckbxNewCheckBox_51 = new JCheckBox("Sunflower Plains");
        checkBoxes.add((Component)chckbxNewCheckBox_51, "2, 52");
        JCheckBox chckbxNewCheckBox_52 = new JCheckBox("Desert M");
        checkBoxes.add((Component)chckbxNewCheckBox_52, "4, 52");
        JCheckBox chckbxNewCheckBox_53 = new JCheckBox("Extreme Hills M");
        checkBoxes.add((Component)chckbxNewCheckBox_53, "2, 54");
        JCheckBox chckbxNewCheckBox_54 = new JCheckBox("Flower Forest");
        checkBoxes.add((Component)chckbxNewCheckBox_54, "4, 54");
        JCheckBox chckbxNewCheckBox_55 = new JCheckBox("Taiga M");
        checkBoxes.add((Component)chckbxNewCheckBox_55, "2, 56");
        JCheckBox chckbxNewCheckBox_56 = new JCheckBox("Swampland M");
        checkBoxes.add((Component)chckbxNewCheckBox_56, "4, 56");
        JCheckBox chckbxNewCheckBox_57 = new JCheckBox("Ice Plains Spikes");
        checkBoxes.add((Component)chckbxNewCheckBox_57, "2, 58");
        JCheckBox chckbxNewCheckBox_58 = new JCheckBox("Jungle M");
        checkBoxes.add((Component)chckbxNewCheckBox_58, "4, 58");
        JCheckBox chckbxNewCheckBox_59 = new JCheckBox("Jungle Edge M");
        checkBoxes.add((Component)chckbxNewCheckBox_59, "2, 60");
        JCheckBox chckbxNewCheckBox_60 = new JCheckBox("Birch Forest M");
        checkBoxes.add((Component)chckbxNewCheckBox_60, "4, 60");
        JCheckBox chckbxNewCheckBox_61 = new JCheckBox("Birch Forest Hills M");
        checkBoxes.add((Component)chckbxNewCheckBox_61, "2, 62");
        JCheckBox chckbxNewCheckBox_62 = new JCheckBox("Roofed Forest M");
        checkBoxes.add((Component)chckbxNewCheckBox_62, "4, 62");
        JCheckBox chckbxNewCheckBox_63 = new JCheckBox("Cold Taiga M");
        checkBoxes.add((Component)chckbxNewCheckBox_63, "2, 64");
        JCheckBox chckbxNewCheckBox_64 = new JCheckBox("Mega Spruce Taiga");
        checkBoxes.add((Component)chckbxNewCheckBox_64, "4, 64");
        JCheckBox chckbxNewCheckBox_65 = new JCheckBox("Mega Spruce Taiga (Hills)");
        checkBoxes.add((Component)chckbxNewCheckBox_65, "2, 66");
        JCheckBox chckbxNewCheckBox_66 = new JCheckBox("Extreme Hills+ M");
        checkBoxes.add((Component)chckbxNewCheckBox_66, "4, 66");
        JCheckBox chckbxNewCheckBox_67 = new JCheckBox("Savanna M");
        checkBoxes.add((Component)chckbxNewCheckBox_67, "2, 68");
        JCheckBox chckbxNewCheckBox_68 = new JCheckBox("Savanna Plateau M");
        checkBoxes.add((Component)chckbxNewCheckBox_68, "4, 68");
        JCheckBox chckbxNewCheckBox_69 = new JCheckBox("Mesa (Bryce)");
        checkBoxes.add((Component)chckbxNewCheckBox_69, "2, 70");
        JCheckBox chckbxNewCheckBox_70 = new JCheckBox("Mesa Plateau F M");
        checkBoxes.add((Component)chckbxNewCheckBox_70, "4, 70");
        JCheckBox chckbxNewCheckBox_71 = new JCheckBox("Mesa Plateau M");
        checkBoxes.add((Component)chckbxNewCheckBox_71, "2, 72");
        JPanel panel_2 = new JPanel();
        this.tabbedPane.addTab("Exclusion", null, panel_2, null);
        panel_2.setLayout(null);
        this.tabbedPane.setEnabledAt(2, false);
        JLabel lblNewLabel1 = new JLabel("Biome Exclusion");
        lblNewLabel1.setBounds(0, 0, 396, 34);
        lblNewLabel1.setHorizontalAlignment(0);
        panel_2.add(lblNewLabel1);
        JScrollPane scrollPane_2 = new JScrollPane();
        scrollPane_2.setHorizontalScrollBarPolicy(31);
        scrollPane_2.setBounds(0, 33, 396, 427);
        panel_2.add(scrollPane_2);
        checkBoxes1 = new JPanel();
        scrollPane_2.setViewportView(checkBoxes1);
        checkBoxes1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        JCheckBox chckbxNewCheckBox_73 = new JCheckBox("Ocean (Always true)");
        checkBoxes1.add((Component)chckbxNewCheckBox_73, "2, 2");
        chckbxNewCheckBox_73.setEnabled(false);
        JCheckBox chckbxNewCheckBox_74 = new JCheckBox("Plains");
        checkBoxes1.add((Component)chckbxNewCheckBox_74, "4, 2");
        JCheckBox chckbxNewCheckBox_75 = new JCheckBox("Desert");
        checkBoxes1.add((Component)chckbxNewCheckBox_75, "2, 4");
        JCheckBox chckbxNewCheckBox_76 = new JCheckBox("Extreme Hills");
        checkBoxes1.add((Component)chckbxNewCheckBox_76, "4, 4");
        JCheckBox chckbxNewCheckBox_77 = new JCheckBox("Forest");
        checkBoxes1.add((Component)chckbxNewCheckBox_77, "2, 6");
        JCheckBox chckbxNewCheckBox_78 = new JCheckBox("Taiga");
        checkBoxes1.add((Component)chckbxNewCheckBox_78, "4, 6");
        JCheckBox chckbxNewCheckBox_79 = new JCheckBox("Swampland");
        checkBoxes1.add((Component)chckbxNewCheckBox_79, "2, 8");
        JCheckBox chckbxNewCheckBox_80 = new JCheckBox("River");
        checkBoxes1.add((Component)chckbxNewCheckBox_80, "4, 8");
        JCheckBox chckbxNewCheckBox_81 = new JCheckBox("Hell");
        checkBoxes1.add((Component)chckbxNewCheckBox_81, "2, 10");
        chckbxNewCheckBox_81.setEnabled(false);
        JCheckBox chckbxNewCheckBox_82 = new JCheckBox("The End");
        checkBoxes1.add((Component)chckbxNewCheckBox_82, "4, 10");
        chckbxNewCheckBox_82.setEnabled(false);
        JCheckBox chckbxNewCheckBox_83 = new JCheckBox("Frozen Ocean");
        checkBoxes1.add((Component)chckbxNewCheckBox_83, "2, 12");
        JCheckBox chckbxNewCheckBox_84 = new JCheckBox("Frozen River");
        checkBoxes1.add((Component)chckbxNewCheckBox_84, "4, 12");
        JCheckBox chckbxNewCheckBox_840 = new JCheckBox("Ice Plains");
        checkBoxes1.add((Component)chckbxNewCheckBox_840, "2, 14");
        JCheckBox chckbxNewCheckBox_85 = new JCheckBox("Ice Mountains");
        checkBoxes1.add((Component)chckbxNewCheckBox_85, "4, 14");
        JCheckBox chckbxNewCheckBox_86 = new JCheckBox("Mushroom Island");
        checkBoxes1.add((Component)chckbxNewCheckBox_86, "2, 16");
        JCheckBox chckbxNewCheckBox_87 = new JCheckBox("Mushroom Island Shore");
        checkBoxes1.add((Component)chckbxNewCheckBox_87, "4, 16");
        JCheckBox chckbxNewCheckBox_88 = new JCheckBox("Beach");
        checkBoxes1.add((Component)chckbxNewCheckBox_88, "2, 18");
        JCheckBox chckbxNewCheckBox_89 = new JCheckBox("Desert Hills");
        checkBoxes1.add((Component)chckbxNewCheckBox_89, "4, 18");
        JCheckBox chckbxNewCheckBox_90 = new JCheckBox("Forest Hills");
        checkBoxes1.add((Component)chckbxNewCheckBox_90, "2, 20");
        JCheckBox chckbxNewCheckBox_91 = new JCheckBox("Extreme Hills Edge");
        checkBoxes1.add((Component)chckbxNewCheckBox_91, "4, 20");
        JCheckBox chckbxNewCheckBox_92 = new JCheckBox("Jungle");
        checkBoxes1.add((Component)chckbxNewCheckBox_92, "2, 22");
        JCheckBox chckbxNewCheckBox_93 = new JCheckBox("Jungle Hills");
        checkBoxes1.add((Component)chckbxNewCheckBox_93, "4, 22");
        JCheckBox chckbxNewCheckBox_94 = new JCheckBox("Jungle Edge");
        checkBoxes1.add((Component)chckbxNewCheckBox_94, "2, 24");
        JCheckBox chckbxNewCheckBox_95 = new JCheckBox("Deep Ocean");
        checkBoxes1.add((Component)chckbxNewCheckBox_95, "4, 24");
        JCheckBox chckbxNewCheckBox_96 = new JCheckBox("Stone Beach");
        checkBoxes1.add((Component)chckbxNewCheckBox_96, "2, 26");
        JCheckBox chckbxNewCheckBox_97 = new JCheckBox("Cold Beach");
        checkBoxes1.add((Component)chckbxNewCheckBox_97, "4, 26");
        JCheckBox chckbxNewCheckBox_98 = new JCheckBox("Birch Forest");
        checkBoxes1.add((Component)chckbxNewCheckBox_98, "2, 28");
        JCheckBox chckbxNewCheckBox_99 = new JCheckBox("Birch Forest Hills");
        checkBoxes1.add((Component)chckbxNewCheckBox_99, "4, 28");
        JCheckBox chckbxNewCheckBox_100 = new JCheckBox("Roofed Forest");
        checkBoxes1.add((Component)chckbxNewCheckBox_100, "2, 30");
        JCheckBox chckbxNewCheckBox_101 = new JCheckBox("Cold Taiga");
        checkBoxes1.add((Component)chckbxNewCheckBox_101, "4, 30");
        JCheckBox chckbxNewCheckBox_102 = new JCheckBox("Cold Taiga Hills");
        checkBoxes1.add((Component)chckbxNewCheckBox_102, "2, 30");
        JCheckBox chckbxNewCheckBox_103 = new JCheckBox("Mega Taiga");
        checkBoxes1.add((Component)chckbxNewCheckBox_103, "2, 32");
        JCheckBox chckbxNewCheckBox_104 = new JCheckBox("Mega Taiga Hills");
        checkBoxes1.add((Component)chckbxNewCheckBox_104, "4, 32");
        JCheckBox chckbxNewCheckBox_105 = new JCheckBox("Extreme Hills+");
        checkBoxes1.add((Component)chckbxNewCheckBox_105, "2, 34");
        JCheckBox chckbxNewCheckBox_106 = new JCheckBox("Savanna");
        checkBoxes1.add((Component)chckbxNewCheckBox_106, "4, 34");
        JCheckBox chckbxNewCheckBox_107 = new JCheckBox("Savanna Plateau");
        checkBoxes1.add((Component)chckbxNewCheckBox_107, "2, 36");
        JCheckBox chckbxNewCheckBox_108 = new JCheckBox("Mesa");
        checkBoxes1.add((Component)chckbxNewCheckBox_108, "4, 36");
        JCheckBox chckbxNewCheckBox_109 = new JCheckBox("Mesa Plateau F");
        checkBoxes1.add((Component)chckbxNewCheckBox_109, "2, 38");
        JCheckBox chckbxNewCheckBox_110 = new JCheckBox("Mesa Plateau");
        checkBoxes1.add((Component)chckbxNewCheckBox_110, "4, 38");
        JCheckBox chckbxNewCheckBox_111 = new JCheckBox("The End - Floating islands");
        checkBoxes1.add((Component)chckbxNewCheckBox_111, "2, 40");
        chckbxNewCheckBox_111.setEnabled(false);
        JCheckBox chckbxNewCheckBox_112 = new JCheckBox("The End - Medium island");
        checkBoxes1.add((Component)chckbxNewCheckBox_112, "4, 40");
        chckbxNewCheckBox_112.setEnabled(false);
        JCheckBox chckbxNewCheckBox_113 = new JCheckBox("The End - High island");
        checkBoxes1.add((Component)chckbxNewCheckBox_113, "2, 42");
        chckbxNewCheckBox_113.setEnabled(false);
        JCheckBox chckbxNewCheckBox_114 = new JCheckBox("The End - Barren island");
        checkBoxes1.add((Component)chckbxNewCheckBox_114, "4, 42");
        chckbxNewCheckBox_114.setEnabled(false);
        JCheckBox chckbxNewCheckBox_115 = new JCheckBox("Warm Ocean");
        checkBoxes1.add((Component)chckbxNewCheckBox_115, "2, 44");
        JCheckBox chckbxNewCheckBox_116 = new JCheckBox("Lukewarm Ocean");
        checkBoxes1.add((Component)chckbxNewCheckBox_116, "4, 44");
        JCheckBox chckbxNewCheckBox_117 = new JCheckBox("Cold Ocean");
        checkBoxes1.add((Component)chckbxNewCheckBox_117, "2, 46");
        JCheckBox chckbxNewCheckBox_118 = new JCheckBox("Warm Deep Ocean");
        checkBoxes1.add((Component)chckbxNewCheckBox_118, "4, 46");
        chckbxNewCheckBox_118.setEnabled(false);
        JCheckBox chckbxNewCheckBox_119 = new JCheckBox("Lukewarm Deep Ocean");
        checkBoxes1.add((Component)chckbxNewCheckBox_119, "2, 48");
        JCheckBox chckbxNewCheckBox_120 = new JCheckBox("Cold Deep Ocean");
        checkBoxes1.add((Component)chckbxNewCheckBox_120, "4, 48");
        JCheckBox chckbxNewCheckBox_121 = new JCheckBox("Frozen Deep Ocean");
        checkBoxes1.add((Component)chckbxNewCheckBox_121, "2, 50");
        JCheckBox chckbxNewCheckBox_122 = new JCheckBox("The Void");
        checkBoxes1.add((Component)chckbxNewCheckBox_122, "4, 50");
        chckbxNewCheckBox_122.setEnabled(false);
        JCheckBox chckbxNewCheckBox_123 = new JCheckBox("Sunflower Plains");
        checkBoxes1.add((Component)chckbxNewCheckBox_123, "2, 52");
        JCheckBox chckbxNewCheckBox_124 = new JCheckBox("Desert M");
        checkBoxes1.add((Component)chckbxNewCheckBox_124, "4, 52");
        JCheckBox chckbxNewCheckBox_125 = new JCheckBox("Extreme Hills M");
        checkBoxes1.add((Component)chckbxNewCheckBox_125, "2, 54");
        JCheckBox chckbxNewCheckBox_126 = new JCheckBox("Flower Forest");
        checkBoxes1.add((Component)chckbxNewCheckBox_126, "4, 54");
        JCheckBox chckbxNewCheckBox_127 = new JCheckBox("Taiga M");
        checkBoxes1.add((Component)chckbxNewCheckBox_127, "2, 56");
        JCheckBox chckbxNewCheckBox_128 = new JCheckBox("Swampland M");
        checkBoxes1.add((Component)chckbxNewCheckBox_128, "4, 56");
        JCheckBox chckbxNewCheckBox_129 = new JCheckBox("Ice Plains Spikes");
        checkBoxes1.add((Component)chckbxNewCheckBox_129, "2, 58");
        JCheckBox chckbxNewCheckBox_130 = new JCheckBox("Jungle M");
        checkBoxes1.add((Component)chckbxNewCheckBox_130, "4, 58");
        JCheckBox chckbxNewCheckBox_131 = new JCheckBox("Jungle Edge M");
        checkBoxes1.add((Component)chckbxNewCheckBox_131, "2, 60");
        JCheckBox chckbxNewCheckBox_132 = new JCheckBox("Birch Forest M");
        checkBoxes1.add((Component)chckbxNewCheckBox_132, "4, 60");
        JCheckBox chckbxNewCheckBox_133 = new JCheckBox("Birch Forest Hills M");
        checkBoxes1.add((Component)chckbxNewCheckBox_133, "2, 62");
        JCheckBox chckbxNewCheckBox_134 = new JCheckBox("Roofed Forest M");
        checkBoxes1.add((Component)chckbxNewCheckBox_134, "4, 62");
        JCheckBox chckbxNewCheckBox_135 = new JCheckBox("Cold Taiga M");
        checkBoxes1.add((Component)chckbxNewCheckBox_135, "2, 64");
        JCheckBox chckbxNewCheckBox_136 = new JCheckBox("Mega Spruce Taiga");
        checkBoxes1.add((Component)chckbxNewCheckBox_136, "4, 64");
        JCheckBox chckbxNewCheckBox_137 = new JCheckBox("Mega Spruce Taiga (Hills)");
        checkBoxes1.add((Component)chckbxNewCheckBox_137, "2, 66");
        JCheckBox chckbxNewCheckBox_138 = new JCheckBox("Extreme Hills+ M");
        checkBoxes1.add((Component)chckbxNewCheckBox_138, "4, 66");
        JCheckBox chckbxNewCheckBox_139 = new JCheckBox("Savanna M");
        checkBoxes1.add((Component)chckbxNewCheckBox_139, "2, 68");
        JCheckBox chckbxNewCheckBox_140 = new JCheckBox("Savanna Plateau M");
        checkBoxes1.add((Component)chckbxNewCheckBox_140, "4, 68");
        JCheckBox chckbxNewCheckBox_141 = new JCheckBox("Mesa (Bryce)");
        checkBoxes1.add((Component)chckbxNewCheckBox_141, "2, 70");
        JCheckBox chckbxNewCheckBox_142 = new JCheckBox("Mesa Plateau F M");
        checkBoxes1.add((Component)chckbxNewCheckBox_142, "4, 70");
        JCheckBox chckbxNewCheckBox_143 = new JCheckBox("Mesa Plateau M");
        checkBoxes1.add((Component)chckbxNewCheckBox_143, "2, 72");
    }

    public static Biome[] manageCheckedCheckboxes() throws UnknownBiomeIndexException, InterruptedException, IOException, FormatException, MinecraftInterfaceCreationException {
        Component[] comps = checkBoxes.getComponents();
        ArrayList<String> checkedTexts = new ArrayList<String>();
        Component[] componentArray = comps;
        int n = comps.length;
        int n2 = 0;
        while (n2 < n) {
            JCheckBox box;
            Component comp = componentArray[n2];
            if (comp instanceof JCheckBox && (box = (JCheckBox)comp).isSelected()) {
                String text = box.getText();
                checkedTexts.add(text);
            }
            ++n2;
        }
        Biome[] biomes = new Biome[checkedTexts.size()];
        int i = 0;
        while (i < checkedTexts.size()) {
            biomes[i] = Biome.getByName((String)checkedTexts.get(i));
            ++i;
        }
        if (biomes.length == 0) {
            Util.console("Please select Biomes!\nPlease click start a few times to start again (Working on a fix)\nRecommend you clear also!");
            GUI.stop();
        }
        return biomes;
    }

    public static Biome[] manageCheckedCheckboxesRejected() throws UnknownBiomeIndexException, InterruptedException, IOException, FormatException, MinecraftInterfaceCreationException {
        Component[] comps = checkBoxes1.getComponents();
        ArrayList<String> checkedTexts = new ArrayList<String>();
        Component[] componentArray = comps;
        int n = comps.length;
        int n2 = 0;
        while (n2 < n) {
            JCheckBox box;
            Component comp = componentArray[n2];
            if (comp instanceof JCheckBox && (box = (JCheckBox)comp).isSelected()) {
                String text = box.getText();
                checkedTexts.add(text);
            }
            ++n2;
        }
        Biome[] biomes = new Biome[checkedTexts.size()];
        int i = 0;
        while (i < checkedTexts.size()) {
            biomes[i] = Biome.getByName((String)checkedTexts.get(i));
            ++i;
        }
        if (biomes.length == 0) {
            Util.console("Please select Biomes!\nPlease click start a few times to start again (Working on a fix)\nRecommend you clear also!");
            GUI.stop();
        }
        return biomes;
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source != "Biomes") {
            // empty if block
        }
        e.getStateChange();
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == btnStart) {
                try {
                    GUI.toggleRunning();
                }
                catch (MinecraftInterfaceCreationException | FormatException | IOException | InterruptedException e1) {
                    e1.printStackTrace();
                }
            } else if (e.getSource() == btnPause) {
                GUI.togglePause();
            } else if (e.getSource() == btnClear) {
                try {
                    GUI.reset();
                }
                catch (MinecraftInterfaceCreationException | FormatException | IOException | InterruptedException e1) {
                    e1.printStackTrace();
                }
            } else if (e.getSource() == excludeBiome) {
                if (excludeBiome.isSelected()) {
                    GUI.this.tabbedPane.setEnabledAt(2, true);
                } else {
                    GUI.this.tabbedPane.setEnabledAt(2, false);
                }
            }
        }
    }
}

