/*
 * Decompiled with CFR 0.152.
 */
package main;

import amidst.mojangapi.world.World;
import amidst.mojangapi.world.coordinates.CoordinatesInWorld;
import amidst.mojangapi.world.icon.WorldIcon;
import java.util.List;

public class StructureSearcher {
    World world;
    public CoordinatesInWorld origin;
    public boolean structureFound;
    public List<WorldIcon> mines;
    public List<WorldIcon> villages;
    public List<WorldIcon> strongholds;
    public List<WorldIcon> temples;
    public List<WorldIcon> mansions;
    public List<WorldIcon> oceanFeatures;
    public List<WorldIcon> oceanMonuments;
    Type[] simpleTypes;
    List[] simpleLists;

    public StructureSearcher() {
        this.origin = this.world.getSpawnWorldIcon().getCoordinates();
        this.structureFound = false;
        this.simpleTypes = new Type[]{Type.MINE, Type.VILLAGE, Type.STRONGHOLD, Type.TEMPLE, Type.MANSION, Type.OCEAN_FEATURE, Type.OCEAN_MONUMENT};
        this.simpleLists = new List[]{this.mines, this.villages, this.strongholds, this.temples, this.mansions, this.oceanFeatures, this.oceanMonuments};
    }

    public void findStructures() {
        for (WorldIcon icon : this.mansions) {
            if (!(this.origin.getDistance(icon.getCoordinates()) <= 100.0)) continue;
            this.structureFound = true;
        }
    }

    private void findMines() {
        this.mines = this.world.getMineshaftProducer().getAt(this.origin, null);
    }

    private void findVillages() {
        this.villages = this.world.getVillageProducer().getAt(this.origin, null);
    }

    private void findOceanMounments() {
        this.oceanMonuments = this.world.getOceanMonumentProducer().getAt(this.origin, null);
    }

    private void findOceanFeatures() {
        this.oceanFeatures = this.world.getOceanFeaturesProducer().getAt(this.origin, null);
    }

    private void findStrongholds() {
        this.strongholds = this.world.getStrongholdProducer().getAt(this.origin, null);
    }

    private void findTemples() {
        this.temples = this.world.getTempleProducer().getAt(this.origin, null);
    }

    private void findMansions() {
        this.mansions = this.world.getWoodlandMansionProducer().getAt(this.origin, null);
    }

    public static enum Type {
        MINE,
        VILLAGE,
        STRONGHOLD,
        TEMPLE,
        MANSION,
        OCEAN_FEATURE,
        OCEAN_MONUMENT,
        SLIME_CHUNK,
        BIOME_DATA;

    }
}

